/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.features;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MetadataUtils {
    private static final Logger LOG = LogManager.getLogger(MetadataUtils.class);

    private MetadataUtils() {
    }

    public static ObjectMetadata generateObjectMetadata(byte[] byteArray) {
        ObjectMetadata metadata = new ObjectMetadata();
        try {
            byte[] md5binary = MessageDigest.getInstance("MD5").digest(byteArray);
            metadata.setContentMD5(BinaryUtils.toBase64((byte[])md5binary));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Cannot calculate MD5 hash of because no MD5 algorithm was found", (Throwable)e);
        }
        metadata.setContentLength((long)byteArray.length);
        return metadata;
    }

    public static ObjectMetadata generateObjectMetadata(String id, InputStream inputStream) {
        ObjectMetadata metadata = new ObjectMetadata();
        byte[] content = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (DigestInputStream dis = new DigestInputStream(inputStream, md);){
                content = IOUtils.toByteArray((InputStream)dis);
                metadata.setContentMD5(BinaryUtils.toBase64((byte[])md.digest()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Cannot calculate MD5 hash of because no MD5 algorithm was found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error reading inputStream for object {}", (Object)id, (Object)e);
        }
        Integer intLength = content.length;
        metadata.setContentLength(intLength.longValue());
        return metadata;
    }
}

