/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.features;

import eu.europeana.domain.ContentValidationException;
import eu.europeana.domain.ObjectMetadata;
import eu.europeana.domain.ObjectStorageClientException;
import eu.europeana.domain.StorageObject;
import eu.europeana.features.ObjectStorageClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.ContextBuilder;
import org.jclouds.io.Payload;
import org.jclouds.io.payloads.ByteArrayPayload;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.ObjectList;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.ContainerApi;
import org.jclouds.openstack.swift.v1.features.ObjectApi;

public class SwiftObjectStorageClient
implements ObjectStorageClient {
    private static final Logger LOG = LogManager.getLogger(SwiftObjectStorageClient.class);
    private ObjectApi objectApi;
    private String bucketName;

    public SwiftObjectStorageClient(String authUrl, String userName, String password, String containerName, String regionName, String tenantName) {
        SwiftApi swiftApi = (SwiftApi)ContextBuilder.newBuilder((String)"openstack-swift").credentials(tenantName + ":" + userName, password).endpoint(authUrl).buildApi(SwiftApi.class);
        ContainerApi containerApi = swiftApi.getContainerApi(regionName);
        if (containerApi.get(containerName) == null && !containerApi.create(containerName)) {
            throw new ObjectStorageClientException("Swift cannot create container: " + containerName);
        }
        this.objectApi = swiftApi.getObjectApi(regionName, containerName);
        this.bucketName = containerName;
    }

    @Override
    public String getName() {
        return "Swift";
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public List<StorageObject> list() {
        ObjectList results = this.objectApi.list();
        ArrayList<StorageObject> storageObjects = new ArrayList<StorageObject>();
        for (SwiftObject so : results) {
            storageObjects.add(this.toStorageObject(so));
        }
        return storageObjects;
    }

    @Override
    public boolean isAvailable(String id) {
        return this.objectApi.getWithoutBody(id) != null;
    }

    @Override
    public String put(String key, Payload value) {
        return this.objectApi.put(key, value);
    }

    private StorageObject toStorageObject(SwiftObject so) {
        ObjectMetadata metadata = new ObjectMetadata();
        so.getMetadata().entrySet().forEach(entry -> metadata.addMetaData((String)entry.getKey(), entry.getValue()));
        return new StorageObject(so.getName(), so.getUri(), metadata, so.getPayload());
    }

    @Override
    public String put(StorageObject storageObject) {
        return this.objectApi.put(storageObject.getName(), storageObject.getPayload());
    }

    @Override
    public Optional<StorageObject> getWithoutBody(String objectName) {
        return Optional.of(this.toStorageObject(this.objectApi.getWithoutBody(objectName)));
    }

    @Override
    public Optional<StorageObject> get(String objectName) {
        return Optional.of(this.toStorageObject(this.objectApi.get(objectName)));
    }

    @Override
    public Optional<StorageObject> get(String objectName, boolean verify) throws ContentValidationException {
        if (verify) {
            throw new IllegalStateException("Verification not implemented yet");
        }
        return Optional.of(this.toStorageObject(this.objectApi.get(objectName)));
    }

    @Override
    public byte[] getContent(String objectName) {
        return (byte[])((ByteArrayPayload)this.objectApi.get(objectName).getPayload()).getRawContent();
    }

    @Override
    public ObjectMetadata getMetaData(String objectName) {
        SwiftObject swiftObject = this.objectApi.getWithoutBody(objectName);
        ObjectMetadata result = new ObjectMetadata();
        result.setETag(swiftObject.getETag());
        result.setLastModified(swiftObject.getLastModified());
        return result;
    }

    @Override
    public void delete(String objectName) {
        this.objectApi.delete(objectName);
    }

    @Override
    public void close() {
        try {
            LOG.info("Shutting down connections to {} ...", (Object)this.getName());
            ((SwiftApi)this.objectApi).close();
        }
        catch (IOException e) {
            LOG.error("Error closing Swift client", (Throwable)e);
        }
    }
}

