/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import eu.europeana.domain.ObjectMetadata;
import java.net.URI;
import java.util.Date;
import org.jclouds.io.Payload;

public class StorageObject
implements Comparable<StorageObject> {
    private final String name;
    private final URI uri;
    private final Payload payload;
    private ObjectMetadata metadata;

    public StorageObject(String name, URI uri, ObjectMetadata metadata, Payload payload) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.uri = uri;
        this.metadata = metadata;
        if (this.metadata == null) {
            this.metadata = new ObjectMetadata();
            if (payload == null) {
                this.metadata.setContentLength(0L);
            } else {
                this.metadata.setContentLength(payload.getContentMetadata().getContentLength());
            }
        }
        this.payload = payload;
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getETag() {
        return this.metadata.getETag();
    }

    public Date getLastModified() {
        return this.metadata.getLastModified();
    }

    public Payload getPayload() {
        return this.payload;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            StorageObject that = (StorageObject)StorageObject.class.cast(object);
            return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getUri(), (Object)that.getUri()) && Objects.equal((Object)this.getETag(), (Object)that.getETag());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getUri(), this.getETag()});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("uri", (Object)this.getUri()).add("etag", (Object)this.getETag()).add("lastModified", (Object)this.getLastModified());
    }

    @Override
    public int compareTo(StorageObject that) {
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        return this.getName().compareTo(that.getName());
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMetadata metadata) {
        this.metadata = metadata;
    }
}

