/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.domain;

import com.amazonaws.util.DateUtils;
import eu.europeana.domain.ObjectStorageClientException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ObjectMetadata
implements Serializable {
    private static final long serialVersionUID = 309391172680920769L;
    private HashMap<String, Object> metadata;

    public ObjectMetadata() {
        this.metadata = new HashMap();
    }

    public ObjectMetadata(Map<String, Object> metadata) {
        if (metadata instanceof HashMap) {
            this.metadata = (HashMap)metadata;
        } else {
            this.metadata = new HashMap();
            this.metadata.putAll(metadata);
        }
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public Map<String, Object> getRawMetadata() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        copy.putAll(this.metadata);
        return Collections.unmodifiableMap(copy);
    }

    public Object getRawMetadataValue(String key) {
        return this.metadata.get(key);
    }

    public Date getLastModified() {
        return DateUtils.cloneDate((Date)((Date)this.metadata.get("Last-Modified")));
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf(47)) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentLanguage() {
        return (String)this.metadata.get("Content-Language");
    }

    public void setContentLanguage(String contentLanguage) {
        this.metadata.put("Content-Language", contentLanguage);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", md5Base64);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public void setETag(String eTag) {
        this.metadata.put("ETag", eTag);
    }

    public Long[] getContentRange() {
        String contentRange = (String)this.metadata.get("Content-Range");
        Long[] range = null;
        if (contentRange != null) {
            String[] tokens = contentRange.split("[ -/]+");
            try {
                range = new Long[]{Long.valueOf(tokens[1]), Long.valueOf(tokens[2])};
            }
            catch (NumberFormatException nfe) {
                throw new ObjectStorageClientException("Unable to parse content range. Header 'Content-Range' has corrupted data" + nfe.getMessage(), nfe);
            }
        }
        return range;
    }

    public void addMetaData(final String key, final Object value) {
        this.metadata.entrySet().add(new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public Object setValue(Object value2) {
                return value2;
            }
        });
    }
}

