/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.model.serialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import eu.europeana.oaipmh.model.Header;
import eu.europeana.oaipmh.model.ListRecords;
import eu.europeana.oaipmh.model.RDFMetadata;
import eu.europeana.oaipmh.model.Record;
import eu.europeana.oaipmh.model.ResumptionToken;
import eu.europeana.oaipmh.model.request.ListRecordsRequest;
import eu.europeana.oaipmh.model.response.ListRecordsResponse;
import eu.europeana.oaipmh.util.DateConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public class ListRecordsResponseDeserializer
extends StdDeserializer<ListRecordsResponse> {
    private static final String RESUMPTION_TOKEN = "resumptionToken";
    private static final long serialVersionUID = -5020158570695784042L;

    public ListRecordsResponseDeserializer() {
        this(null);
    }

    public ListRecordsResponseDeserializer(Class<?> vc) {
        super(vc);
    }

    public ListRecordsResponse deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode mainNode = node.get("OAI-PMH");
        JsonNode requestNode = mainNode.get("request");
        JsonNode responseDateNode = mainNode.get("responseDate");
        ListRecordsRequest listRecordsRequest = this.getListRecordsRequest(requestNode);
        ListRecordsResponse listRecordsResponse = new ListRecordsResponse();
        listRecordsResponse.setResponseDate(DateConverter.fromIsoDateTime(responseDateNode.asText()));
        listRecordsResponse.setRequest(listRecordsRequest);
        JsonNode errorNode = mainNode.get("error");
        if (errorNode != null) {
            LogManager.getLogger(ListRecordsResponseDeserializer.class).error("Error message: {}", (Object)errorNode);
            return listRecordsResponse;
        }
        JsonNode listRecordsNode = mainNode.get("ListRecords");
        JsonNode recordNode = listRecordsNode.get("record");
        ListRecords listRecords = new ListRecords();
        listRecords.setResumptionToken(this.getResumptionToken(listRecordsNode.get(RESUMPTION_TOKEN)));
        listRecords.setRecords(this.getRecords(recordNode));
        listRecordsResponse.setListRecords(listRecords);
        return listRecordsResponse;
    }

    private List<Record> getRecords(JsonNode node) throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        if (node.isArray()) {
            for (int i = 0; i < node.size(); ++i) {
                records.add(this.getRecord(node.get(i)));
            }
        } else {
            records.add(this.getRecord(node));
        }
        return records;
    }

    private Record getRecord(JsonNode recordNode) throws IOException {
        if (recordNode != null) {
            Record record = new Record();
            record.setHeader(this.getHeader(recordNode.get("header")));
            ObjectMapper mapper = new ObjectMapper();
            RDFMetadata metadata = (RDFMetadata)mapper.readValue(recordNode.get("metadata").toString(), RDFMetadata.class);
            record.setMetadata(metadata);
            return record;
        }
        return null;
    }

    private Header getHeader(JsonNode headerNode) {
        Header headerObject = new Header();
        JsonNode id = headerNode.get("identifier");
        this.setIdentifier(headerNode, headerObject, id);
        JsonNode dateNode = headerNode.get("datestamp");
        this.setDatestamp(headerNode, headerObject, dateNode);
        JsonNode setSpecNode = headerNode.get("setSpec");
        this.setSetSpec(headerObject, setSpecNode);
        return headerObject;
    }

    private void setSetSpec(Header headerObject, JsonNode setSpecNode) {
        if (setSpecNode != null) {
            if (setSpecNode.isArray()) {
                for (int s = 0; s < setSpecNode.size(); ++s) {
                    JsonNode setSpecEntry = setSpecNode.get(s);
                    headerObject.setSetSpec(setSpecEntry.get(0).asText());
                }
            } else {
                headerObject.setSetSpec(setSpecNode.asText());
            }
        }
    }

    private void setDatestamp(JsonNode headerNode, Header headerObject, JsonNode dateNode) {
        if (dateNode != null) {
            headerObject.setDatestamp(DateConverter.fromIsoDateTime(headerNode.get("datestamp").asText()));
        }
    }

    private void setIdentifier(JsonNode headerNode, Header headerObject, JsonNode id) {
        if (id == null) {
            LogManager.getLogger(ListRecordsResponseDeserializer.class).error("No id found in header! ");
        } else {
            headerObject.setIdentifier(headerNode.get("identifier").asText());
        }
    }

    private ResumptionToken getResumptionToken(JsonNode resumptionTokenNode) {
        if (resumptionTokenNode != null) {
            ResumptionToken token = new ResumptionToken();
            token.setValue(resumptionTokenNode.get("content").asText());
            token.setExpirationDate(DateConverter.fromIsoDateTime(resumptionTokenNode.get("expirationDate").asText()));
            token.setCursor(resumptionTokenNode.get("cursor").asLong());
            token.setCompleteListSize(resumptionTokenNode.get("completeListSize").asLong());
            return token;
        }
        return null;
    }

    private ListRecordsRequest getListRecordsRequest(JsonNode request) {
        ListRecordsRequest listRecordsRequest = new ListRecordsRequest(request.get("verb").asText(), request.get("content").asText());
        if (request.get("from") != null) {
            listRecordsRequest.setFrom(request.get("from").asText());
        }
        if (request.get("until") != null) {
            listRecordsRequest.setUntil(request.get("until").asText());
        }
        if (request.get("set") != null) {
            listRecordsRequest.setSet(request.get("set").asText());
        }
        if (request.get("metadataPrefix") != null) {
            listRecordsRequest.setMetadataPrefix(request.get("metadataPrefix").asText());
        }
        if (request.get(RESUMPTION_TOKEN) != null) {
            listRecordsRequest.setResumptionToken(request.get(RESUMPTION_TOKEN).asText());
        }
        return listRecordsRequest;
    }
}

