/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.model.serialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import eu.europeana.oaipmh.model.GetRecord;
import eu.europeana.oaipmh.model.Header;
import eu.europeana.oaipmh.model.RDFMetadata;
import eu.europeana.oaipmh.model.Record;
import eu.europeana.oaipmh.model.request.GetRecordRequest;
import eu.europeana.oaipmh.model.response.GetRecordResponse;
import eu.europeana.oaipmh.util.DateConverter;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;

public class GetRecordResponseDeserializer
extends StdDeserializer<GetRecordResponse> {
    private static final String IDENTIFIER = "identifier";
    private static final long serialVersionUID = -7632541972408801034L;

    public GetRecordResponseDeserializer() {
        this(null);
    }

    private GetRecordResponseDeserializer(Class<?> vc) {
        super(vc);
    }

    public GetRecordResponse deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode mainNode = node.get("OAI-PMH");
        JsonNode requestNode = mainNode.get("request");
        JsonNode responseDateNode = mainNode.get("responseDate");
        GetRecordRequest getRecordRequest = this.getGetRecordRequest(requestNode);
        GetRecordResponse getRecordResponse = new GetRecordResponse();
        getRecordResponse.setResponseDate(DateConverter.fromIsoDateTime(responseDateNode.asText()));
        getRecordResponse.setRequest(getRecordRequest);
        JsonNode errorNode = mainNode.get("error");
        if (errorNode != null) {
            LogManager.getLogger(GetRecordResponseDeserializer.class).error("Error message: {}", (Object)errorNode);
            return getRecordResponse;
        }
        JsonNode getRecordNode = mainNode.get("GetRecord");
        JsonNode recordNode = getRecordNode.get("record");
        JsonNode headerNode = recordNode.get("header");
        GetRecord getRecord = new GetRecord();
        Record record = new Record();
        record.setHeader(this.getHeader(headerNode));
        ObjectMapper mapper = new ObjectMapper();
        RDFMetadata metadata = (RDFMetadata)mapper.readValue(recordNode.get("metadata").toString(), RDFMetadata.class);
        record.setMetadata(metadata);
        getRecord.setRecord(record);
        getRecordResponse.setGetRecord(getRecord);
        return getRecordResponse;
    }

    private Header getHeader(JsonNode header) {
        JsonNode setSpecNode;
        Header headerObject = new Header();
        JsonNode id = header.get(IDENTIFIER);
        if (id == null) {
            LogManager.getLogger(GetRecordResponseDeserializer.class).error("No id found in header! {}", (Object)header.textValue());
        } else {
            headerObject.setIdentifier(header.get(IDENTIFIER).asText());
        }
        JsonNode dateNode = header.get("datestamp");
        if (dateNode != null) {
            headerObject.setDatestamp(DateConverter.fromIsoDateTime(header.get("datestamp").asText()));
        }
        if ((setSpecNode = header.get("setSpec")) != null) {
            if (setSpecNode.isArray()) {
                for (int s = 0; s < setSpecNode.size(); ++s) {
                    JsonNode setSpecEntry = setSpecNode.get(s);
                    headerObject.setSetSpec(setSpecEntry.get(0).asText());
                }
            } else {
                headerObject.setSetSpec(setSpecNode.asText());
            }
        }
        return headerObject;
    }

    private GetRecordRequest getGetRecordRequest(JsonNode request) {
        GetRecordRequest getRecordRequest = new GetRecordRequest(request.get("verb").asText(), request.get("content").asText());
        if (request.get(IDENTIFIER) != null) {
            getRecordRequest.setIdentifier(request.get(IDENTIFIER).asText());
        }
        if (request.get("metadataPrefix") != null) {
            getRecordRequest.setMetadataPrefix(request.get("metadataPrefix").asText());
        }
        return getRecordRequest;
    }
}

