/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.util;

import eu.europeana.oaipmh.model.ResumptionToken;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ResumptionTokenHelper {
    private static final String TOKEN_SEPARATOR = "|";
    private static final String TOKEN_TEMPLATE = "%s|%s|%s|%s|%s|%s|%s|%s";
    private static final byte FROM_INDEX = 0;
    private static final byte UNTIL_INDEX = 1;
    private static final byte SET_INDEX = 2;
    private static final byte FORMAT_INDEX = 3;
    private static final byte EXPIRATION_TIME_INDEX = 4;
    private static final byte COMPLETE_LIST_SIZE_INDEX = 5;
    private static final byte CURSOR_INDEX = 6;
    private static final byte CURSOR_MARK_INDEX = 7;

    private ResumptionTokenHelper() {
    }

    public static ResumptionToken createResumptionToken(String from, String until, String set, String format, Date expirationDate, long completeListSize, long cursor, String nextCursorMark) {
        String tokenEncoded = ResumptionTokenHelper.encodeToken(from, until, set, format, expirationDate, completeListSize, cursor, nextCursorMark);
        return new ResumptionToken(tokenEncoded, completeListSize, expirationDate, cursor);
    }

    public static ResumptionToken createResumptionToken(Date expirationDate, long completeListSize, long cursor) {
        return ResumptionTokenHelper.createResumptionToken(null, null, null, null, expirationDate, completeListSize, cursor, null);
    }

    private static String getTokenPart(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private static String encodeToken(String from, String until, String set, String format, Date expirationDate, long completeListSize, long cursor, String nextCursorMark) {
        String token = String.format(TOKEN_TEMPLATE, ResumptionTokenHelper.getTokenPart(from), ResumptionTokenHelper.getTokenPart(until), ResumptionTokenHelper.getTokenPart(set), ResumptionTokenHelper.getTokenPart(format), expirationDate.getTime(), completeListSize, cursor, nextCursorMark);
        return Base64.getUrlEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    public static ResumptionToken decodeResumptionToken(String base64EncodedToken) {
        try {
            String decoded = new String(Base64.getUrlDecoder().decode(base64EncodedToken), StandardCharsets.UTF_8);
            String[] parts = ResumptionTokenHelper.tokenize(decoded);
            Date expirationDate = new Date(Long.valueOf(parts[4]));
            long cursor = Long.parseLong(parts[6]);
            long completeListSize = Long.parseLong(parts[5]);
            return new ResumptionToken(decoded, completeListSize, expirationDate, cursor);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    private static String[] tokenize(String token) {
        String[] parts = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)token, (String)TOKEN_SEPARATOR);
        if (parts.length == 8) {
            return parts;
        }
        throw new IllegalArgumentException();
    }

    public static String getFrom(String token) {
        return ResumptionTokenHelper.tokenize(token)[0];
    }

    public static String getUntil(String token) {
        return ResumptionTokenHelper.tokenize(token)[1];
    }

    public static String getSet(String token) {
        return ResumptionTokenHelper.tokenize(token)[2];
    }

    public static String getFormat(String token) {
        return ResumptionTokenHelper.tokenize(token)[3];
    }

    public static Date getExpirationDate(String token) {
        return new Date(Long.valueOf(ResumptionTokenHelper.tokenize(token)[4]));
    }

    public static long getCompleteListSize(String token) {
        return Long.parseLong(ResumptionTokenHelper.tokenize(token)[5]);
    }

    public static long getCursor(String token) {
        return Long.parseLong(ResumptionTokenHelper.tokenize(token)[6]);
    }

    public static String getCursorMark(String token) {
        return ResumptionTokenHelper.tokenize(token)[7];
    }
}

