/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.client;

import eu.europeana.oaipmh.client.BaseQuery;
import eu.europeana.oaipmh.client.ListIdentifiersQuery;
import eu.europeana.oaipmh.client.ListRecordsExecutor;
import eu.europeana.oaipmh.client.ListRecordsResult;
import eu.europeana.oaipmh.client.OAIPMHQuery;
import eu.europeana.oaipmh.client.OAIPMHServiceClient;
import eu.europeana.oaipmh.client.ProgressLogger;
import eu.europeana.oaipmh.model.ListRecords;
import eu.europeana.oaipmh.model.response.ListRecordsResponse;
import eu.europeana.oaipmh.service.exception.OaiPmhException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ListRecordsQuery
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(ListRecordsQuery.class);
    @Value(value="${ListRecords.metadataPrefix}")
    private String metadataPrefix;
    @Value(value="${ListRecords.from}")
    private String from;
    @Value(value="${ListRecords.until}")
    private String until;
    @Value(value="${ListRecords.set}")
    private String set;
    @Value(value="${ListRecords.useGetRecord}")
    private boolean useGetRecord;
    @Value(value="${ListRecords.threads}")
    private int threads;
    private ExecutorService threadPool;
    @Value(value="${LogProgress.interval}")
    private Integer logProgressInterval;
    private List<String> sets = new ArrayList<String>();

    @PostConstruct
    public void initSets() {
        if (this.set != null && !this.set.isEmpty()) {
            this.sets.addAll(Arrays.asList(this.set.split(",")));
        }
    }

    private void initThreadPool() {
        if (this.threads < 1) {
            this.threads = 1;
        }
        this.threadPool = Executors.newFixedThreadPool(this.threads);
    }

    @Override
    public String getVerbName() {
        return this.useGetRecord ? "ListIdentifiers" : "ListRecords";
    }

    @Override
    public void execute(OAIPMHServiceClient oaipmhServer) throws OaiPmhException {
        if (this.sets.isEmpty()) {
            this.execute(oaipmhServer, null);
        } else {
            for (String setIdentifier : this.sets) {
                this.execute(oaipmhServer, setIdentifier);
            }
        }
    }

    private void execute(OAIPMHServiceClient oaipmhServer, String setIdentifier) {
        if (this.useGetRecord) {
            this.executeMultithreadListRecords(oaipmhServer, setIdentifier);
        } else {
            this.executeListRecords(oaipmhServer, setIdentifier);
        }
    }

    private void executeMultithreadListRecords(OAIPMHServiceClient oaipmhServer, String setIdentifier) {
        this.initThreadPool();
        long counter = 0L;
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger(-1L, this.logProgressInterval);
        ListIdentifiersQuery identifiersQuery = this.prepareListIdentifiersQuery(setIdentifier);
        List<String> identifiers = identifiersQuery.getIdentifiers(oaipmhServer);
        logger.setTotalItems(identifiers.size());
        List results = null;
        ArrayList<ListRecordsExecutor> tasks = new ArrayList<ListRecordsExecutor>();
        int perThread = identifiers.size() / this.threads;
        for (int i = 0; i < this.threads; ++i) {
            int fromIndex = i * perThread;
            int toIndex = (i + 1) * perThread;
            if (i == this.threads - 1) {
                toIndex = identifiers.size();
            }
            tasks.add(new ListRecordsExecutor(identifiers.subList(fromIndex, toIndex), this.metadataPrefix, oaipmhServer, this.logProgressInterval));
        }
        try {
            results = this.threadPool.invokeAll(tasks);
            for (Future result : results) {
                ListRecordsResult listRecordsResult = (ListRecordsResult)result.get();
                LOG.info("Executor finished with {} errors in {} sec.", (Object)listRecordsResult.getErrors(), (Object)Float.valueOf(listRecordsResult.getTime()));
                logger.logProgress(counter += (long)perThread);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOG.error("Problem with task thread execution.", (Throwable)e);
        }
        this.clean();
        LOG.info("ListRecords for set " + setIdentifier + " executed in " + ProgressLogger.getDurationText(System.currentTimeMillis() - start) + ". Harvested " + identifiers.size() + " identifiers.");
    }

    private void executeListRecords(OAIPMHServiceClient oaipmhServer, String setIdentifier) {
        long counter = 0L;
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger(-1L, this.logProgressInterval);
        String request = this.getRequest(oaipmhServer.getOaipmhServer(), setIdentifier);
        ListRecordsResponse response = (ListRecordsResponse)oaipmhServer.makeRequest(request, ListRecordsResponse.class);
        ListRecords responseObject = response.getListRecords();
        if (responseObject != null) {
            counter += (long)responseObject.getRecords().size();
            if (responseObject.getResumptionToken() != null) {
                logger.setTotalItems(responseObject.getResumptionToken().getCompleteListSize());
            } else {
                logger.setTotalItems(responseObject.getRecords().size());
            }
            while (responseObject.getResumptionToken() != null && (responseObject = (response = (ListRecordsResponse)oaipmhServer.makeRequest(request = this.getResumptionRequest(oaipmhServer.getOaipmhServer(), responseObject.getResumptionToken().getValue()), ListRecordsResponse.class)).getListRecords()) != null) {
                logger.logProgress(counter += (long)responseObject.getRecords().size());
            }
        }
        LOG.info("ListRecords for set " + setIdentifier + " executed in " + ProgressLogger.getDurationText(System.currentTimeMillis() - start) + ". Harvested " + counter + " records.");
    }

    private ListIdentifiersQuery prepareListIdentifiersQuery(String setIdentifier) {
        ListIdentifiersQuery query = new ListIdentifiersQuery(this.metadataPrefix, this.from, this.until, setIdentifier, 30);
        query.initSets();
        return query;
    }

    private String getResumptionRequest(String oaipmhServer, String resumptionToken) {
        return this.getBaseRequest(oaipmhServer, this.getVerbName()) + String.format("&resumptionToken=%s", resumptionToken);
    }

    private String getRequest(String oaipmhServer, String setIdentifier) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseRequest(oaipmhServer, this.getVerbName()));
        sb.append(String.format("&metadataPrefix=%s", this.metadataPrefix));
        if (this.from != null && !this.from.isEmpty()) {
            sb.append(String.format("&from=%s", this.from));
        }
        if (this.until != null && !this.until.isEmpty()) {
            sb.append(String.format("&until=%s", this.until));
        }
        if (this.set != null) {
            sb.append(String.format("&set=%s", setIdentifier));
        }
        return sb.toString();
    }

    @PreDestroy
    private void clean() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }
}

