/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.client;

import eu.europeana.oaipmh.client.GetRecordQuery;
import eu.europeana.oaipmh.client.ListRecordsResult;
import eu.europeana.oaipmh.client.OAIPMHServiceClient;
import eu.europeana.oaipmh.client.ProgressLogger;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListRecordsExecutor
implements Callable<ListRecordsResult> {
    private static final Logger LOG = LogManager.getLogger(ListRecordsExecutor.class);
    private static final int MAX_ERRORS_PER_THREAD = 30;
    private static ProgressLogger logger = null;
    private static long loggerThreadId;
    private int logProgressInterval;
    private List<String> identifiers;
    private String metadataPrefix;
    private OAIPMHServiceClient oaipmhServer;

    public ListRecordsExecutor(List<String> identifiers, String metadataPrefix, OAIPMHServiceClient oaipmhServer, int logProgressInterval) {
        this.identifiers = identifiers;
        this.metadataPrefix = metadataPrefix;
        this.oaipmhServer = oaipmhServer;
        this.logProgressInterval = logProgressInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecordsResult call() throws Exception {
        int errors = 0;
        long counter = 0L;
        long start = System.currentTimeMillis();
        ListRecordsExecutor listRecordsExecutor = this;
        synchronized (listRecordsExecutor) {
            if (logger == null) {
                logger = new ProgressLogger(this.identifiers.size(), this.logProgressInterval);
                loggerThreadId = Thread.currentThread().getId();
                LOG.debug("Created new progress logger for thread {} - {} items, logging interval {} ms", (Object)loggerThreadId, (Object)this.identifiers.size(), (Object)this.logProgressInterval);
            }
        }
        for (String identifier : this.identifiers) {
            block7: {
                try {
                    new GetRecordQuery(this.metadataPrefix, identifier).execute(this.oaipmhServer);
                }
                catch (Exception e) {
                    LOG.error("Error retrieving record {}", (Object)identifier, (Object)e);
                    if (++errors <= 30) break block7;
                    LOG.error("Terminating GetRecord thread {} because too many errors occurred", (Object)Thread.currentThread().getId());
                    break;
                }
            }
            if (Thread.currentThread().getId() != loggerThreadId) continue;
            logger.logProgress(++counter);
        }
        return new ListRecordsResult((float)(System.currentTimeMillis() - start) / 1000.0f, errors);
    }
}

