/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.client;

import eu.europeana.oaipmh.client.BaseQuery;
import eu.europeana.oaipmh.client.LogFile;
import eu.europeana.oaipmh.client.OAIPMHQuery;
import eu.europeana.oaipmh.client.OAIPMHServiceClient;
import eu.europeana.oaipmh.client.ProgressLogger;
import eu.europeana.oaipmh.model.Header;
import eu.europeana.oaipmh.model.ListIdentifiers;
import eu.europeana.oaipmh.model.response.ListIdentifiersResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ListIdentifiersQuery
extends BaseQuery
implements OAIPMHQuery {
    private static final Logger LOG = LogManager.getLogger(ListIdentifiersQuery.class);
    @Value(value="${ListIdentifiers.metadataPrefix}")
    private String metadataPrefix;
    @Value(value="${ListIdentifiers.from}")
    private String from;
    @Value(value="${ListIdentifiers.until}")
    private String until;
    @Value(value="${ListIdentifiers.set}")
    private String set;
    @Value(value="${LogProgress.interval}")
    private Integer logProgressInterval;
    private List<String> sets = new ArrayList<String>();

    public ListIdentifiersQuery() {
    }

    public ListIdentifiersQuery(String metadataPrefix, String from, String until, String set, int logProgressInterval) {
        this.metadataPrefix = metadataPrefix;
        this.from = from;
        this.until = until;
        this.set = set;
        this.logProgressInterval = logProgressInterval;
    }

    @PostConstruct
    public void initSets() {
        if (this.set != null && !this.set.isEmpty()) {
            this.sets.addAll(Arrays.asList(this.set.split(",")));
        }
    }

    @Override
    public String getVerbName() {
        return "ListIdentifiers";
    }

    @Override
    public void execute(OAIPMHServiceClient oaipmhServer) {
        if (this.sets.isEmpty()) {
            this.execute(oaipmhServer, null, null);
        } else {
            for (String setName : this.sets) {
                this.execute(oaipmhServer, setName, null);
            }
        }
    }

    public List<String> getIdentifiers(OAIPMHServiceClient oaipmhServer) {
        ArrayList<String> identifiers = new ArrayList<String>();
        if (this.sets.isEmpty()) {
            this.execute(oaipmhServer, null, identifiers);
        } else {
            for (String setName : this.sets) {
                this.execute(oaipmhServer, setName, identifiers);
            }
        }
        return identifiers;
    }

    private void execute(OAIPMHServiceClient oaipmhServer, String setName, List<String> identifiers) {
        long counter = 0L;
        long start = System.currentTimeMillis();
        ProgressLogger logger = new ProgressLogger(-1L, this.logProgressInterval);
        String request = this.getRequest(oaipmhServer.getOaipmhServer(), setName);
        ListIdentifiersResponse response = (ListIdentifiersResponse)oaipmhServer.makeRequest(request, ListIdentifiersResponse.class);
        ListIdentifiers responseObject = response.getListIdentifiers();
        if (responseObject != null) {
            counter += (long)responseObject.getHeaders().size();
            if (responseObject.getResumptionToken() != null) {
                logger.setTotalItems(responseObject.getResumptionToken().getCompleteListSize());
            } else {
                logger.setTotalItems(responseObject.getHeaders().size());
            }
            this.collectIdentifiers(responseObject.getHeaders(), identifiers);
            while (responseObject.getResumptionToken() != null && (responseObject = (response = (ListIdentifiersResponse)oaipmhServer.makeRequest(request = this.getResumptionRequest(oaipmhServer.getOaipmhServer(), responseObject.getResumptionToken().getValue()), ListIdentifiersResponse.class)).getListIdentifiers()) != null) {
                logger.logProgress(counter += (long)responseObject.getHeaders().size());
                this.collectIdentifiers(responseObject.getHeaders(), identifiers);
            }
        }
        LOG.info("ListIdentifiers for set " + setName + " executed in " + ProgressLogger.getDurationText(System.currentTimeMillis() - start) + ". Harvested " + counter + " identifiers.");
    }

    private void writeDataToLogFile(ListIdentifiers responseObject) {
        ListIterator it = responseObject.getHeaders().listIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            LogFile.OUT.info("{} {}", header.getSetSpec().get(0), (Object)header.getIdentifier());
        }
    }

    private void collectIdentifiers(List<Header> headers, List<String> identifiers) {
        if (identifiers != null) {
            for (Header header : headers) {
                identifiers.add(header.getIdentifier());
            }
        }
    }

    private String getResumptionRequest(String oaipmhServer, String resumptionToken) {
        return this.getBaseRequest(oaipmhServer, this.getVerbName()) + String.format("&resumptionToken=%s", resumptionToken);
    }

    private String getRequest(String oaipmhServer, String set) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseRequest(oaipmhServer, this.getVerbName()));
        sb.append(String.format("&metadataPrefix=%s", this.metadataPrefix));
        if (this.from != null && !this.from.isEmpty()) {
            sb.append(String.format("&from=%s", this.from));
        }
        if (this.until != null && !this.until.isEmpty()) {
            sb.append(String.format("&until=%s", this.until));
        }
        if (set != null) {
            sb.append(String.format("&set=%s", set));
        }
        return sb.toString();
    }
}

