/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.client;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Duration;
import org.joda.time.Period;

public class ProgressLogger {
    private static final Logger LOG = LogManager.getLogger(ProgressLogger.class);
    private long startTime;
    private long totalItems;
    private int logAfterSeconds;
    private long lastLogTime;

    public ProgressLogger(long totalItems, int logAfterSeconds) {
        this.lastLogTime = this.startTime = System.currentTimeMillis();
        this.totalItems = totalItems;
        this.logAfterSeconds = logAfterSeconds;
    }

    public void setTotalItems(long totalItems) {
        this.totalItems = totalItems;
    }

    public void logProgress(long itemsDone) {
        Duration d = new Duration(this.lastLogTime, System.currentTimeMillis());
        if (this.logAfterSeconds > 0 && d.getMillis() / 1000L > (long)this.logAfterSeconds) {
            if (this.totalItems > 0L) {
                Double itemsPerMS = (double)itemsDone * 1.0 / (double)(System.currentTimeMillis() - this.startTime);
                if (itemsPerMS * 1000.0 > 1.0) {
                    LOG.info("Retrieved {} items of {} ({} records/sec). Expected time remaining is {}", (Object)itemsDone, (Object)this.totalItems, (Object)Math.round(itemsPerMS * 1000.0), (Object)ProgressLogger.getDurationText(Math.round((double)(this.totalItems - itemsDone) / itemsPerMS)));
                } else {
                    LOG.info("Retrieved {} items of {} ({} records/min). Expected time remaining is {}", (Object)itemsDone, (Object)this.totalItems, (Object)Math.round(itemsPerMS * 1000.0 * 60.0), (Object)ProgressLogger.getDurationText(Math.round((double)(this.totalItems - itemsDone) / itemsPerMS)));
                }
            } else {
                LOG.info("Retrieved {} items");
            }
            this.lastLogTime = System.currentTimeMillis();
        }
    }

    public static String getDurationText(long durationInMs) {
        Period period = new Period(durationInMs);
        String result = period.getDays() >= 1 ? String.format("%d days, %d hours and %d minutes", period.getDays(), period.getHours(), period.getMinutes()) : (period.getHours() >= 1 ? String.format("%d hours and %d minutes", period.getHours(), period.getMinutes()) : (period.getMinutes() >= 1 ? String.format("%d minutes and %d seconds", period.getMinutes(), period.getSeconds()) : String.format("%d.%d seconds", period.getSeconds(), period.getMillis())));
        return result;
    }
}

