/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.oaipmh.client;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import eu.europeana.oaipmh.client.GetRecordQuery;
import eu.europeana.oaipmh.client.ListIdentifiersQuery;
import eu.europeana.oaipmh.client.ListRecordsQuery;
import eu.europeana.oaipmh.client.OAIPMHQuery;
import eu.europeana.oaipmh.model.RDFMetadata;
import eu.europeana.oaipmh.model.response.GetRecordResponse;
import eu.europeana.oaipmh.model.response.ListIdentifiersResponse;
import eu.europeana.oaipmh.model.response.ListRecordsResponse;
import eu.europeana.oaipmh.model.response.OAIResponse;
import eu.europeana.oaipmh.model.serialize.GetRecordResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.ListIdentifiersResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.ListRecordsResponseDeserializer;
import eu.europeana.oaipmh.model.serialize.RDFMetadataDeserializer;
import eu.europeana.oaipmh.service.exception.OaiPmhException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class OAIPMHServiceClient {
    private static final Logger LOG = LogManager.getLogger(OAIPMHServiceClient.class);
    @Value(value="${oaipmhServer}")
    private String oaipmhServer;
    private RestTemplate restTemplate = new RestTemplate();
    private ObjectMapper mapper;
    @Autowired
    private ListIdentifiersQuery listIdentifiersQuery;
    @Autowired
    private GetRecordQuery getRecordQuery;
    @Autowired
    private ListRecordsQuery listRecordsQuery;
    private Map<String, OAIPMHQuery> queries = new HashMap<String, OAIPMHQuery>();

    @PostConstruct
    public void init() {
        this.queries.put("ListIdentifiers", this.listIdentifiersQuery);
        this.queries.put("GetRecord", this.getRecordQuery);
        this.queries.put("ListRecords", this.listRecordsQuery);
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ListIdentifiersResponse.class, (JsonDeserializer)new ListIdentifiersResponseDeserializer());
        module.addDeserializer(GetRecordResponse.class, (JsonDeserializer)new GetRecordResponseDeserializer());
        module.addDeserializer(RDFMetadata.class, (JsonDeserializer)new RDFMetadataDeserializer());
        module.addDeserializer(ListRecordsResponse.class, (JsonDeserializer)new ListRecordsResponseDeserializer());
        this.mapper.registerModule((Module)module);
        LOG.info("Using OAI-PMH server at " + this.oaipmhServer);
    }

    public String getOaipmhServer() {
        return this.oaipmhServer;
    }

    public void execute(String verb) throws OaiPmhException {
        OAIPMHQuery verbToExecute = this.queries.get(verb);
        if (verbToExecute != null) {
            verbToExecute.execute(this);
        }
    }

    public OAIResponse makeRequest(String request, Class<? extends OAIResponse> responseClass) {
        OAIResponse response = null;
        String responseAsString = (String)this.restTemplate.getForObject(request, String.class, new Object[0]);
        String json = XML.toJSONObject((String)responseAsString).toString();
        try {
            response = (OAIResponse)this.mapper.readValue(json, responseClass);
        }
        catch (IOException e) {
            LOG.error("Exception when deserializing response.", (Throwable)e);
        }
        return response;
    }
}

