/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

final class EDMParser {
    private static EDMParser p;
    private static final ConcurrentMap<String, Schema> CACHE;
    private static final DocumentBuilderFactory PARSE_FACTORY;
    private static final Logger LOGGER;

    private EDMParser() {
    }

    public DocumentBuilder getEdmParser() throws EDMParseSetupException {
        try {
            return PARSE_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EDMParseSetupException("Unable to configure parser", e);
        }
    }

    public Validator getEdmValidator(String path, LSResourceResolver resolver) throws EDMParseSetupException {
        try {
            Validator result = this.getSchema(path, resolver).newValidator();
            return result;
        }
        catch (IOException | SAXException e) {
            throw new EDMParseSetupException("Unable to create validator", e);
        }
    }

    private Schema getSchema(String path, LSResourceResolver resolver) throws SAXException, IOException {
        if (!CACHE.containsKey(path)) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(resolver);
            factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            factory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Schema schema = factory.newSchema(new StreamSource(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0])));
            CACHE.put(path, schema);
        }
        return (Schema)CACHE.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EDMParser getInstance() {
        Class<EDMParser> clazz = EDMParser.class;
        synchronized (EDMParser.class) {
            if (p == null) {
                p = new EDMParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return p;
        }
    }

    static {
        CACHE = new ConcurrentHashMap<String, Schema>();
        PARSE_FACTORY = DocumentBuilderFactory.newInstance();
        LOGGER = LoggerFactory.getLogger(EDMParser.class);
        try {
            PARSE_FACTORY.setNamespaceAware(true);
            PARSE_FACTORY.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            PARSE_FACTORY.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            PARSE_FACTORY.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            PARSE_FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Unable to create DocumentBuilderFactory", (Throwable)e);
        }
    }

    public static class EDMParseSetupException
    extends Exception {
        private static final long serialVersionUID = 3854029647081914787L;

        EDMParseSetupException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

