/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.Schema;
import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.EDMParser;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.SchemaProviderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator
implements Callable<ValidationResult> {
    private static final String NODE_ID_ATTR = "nodeId";
    private static final Logger LOGGER = LoggerFactory.getLogger(Validator.class);
    private static final ConcurrentMap<String, Templates> templatesCache = new ConcurrentHashMap<String, Templates>();
    private final String schema;
    private final String rootFileLocation;
    private final String schematronFileLocation;
    private final InputStream document;
    private final SchemaProvider schemaProvider;
    private final ClasspathResourceResolver resolver;

    public Validator(String schema, String rootFileLocation, String schematronFileLocation, InputStream document, SchemaProvider schemaProvider, ClasspathResourceResolver resolver) {
        this.schema = schema;
        this.rootFileLocation = rootFileLocation;
        this.schematronFileLocation = schematronFileLocation;
        this.document = document;
        this.schemaProvider = schemaProvider;
        this.resolver = resolver;
    }

    private Schema getSchemaByName(String schemaName) throws SchemaProviderException {
        Schema schemaObject;
        if (this.schemaProvider.isPredefined(schemaName)) {
            schemaObject = this.schemaProvider.getSchema(schemaName);
        } else {
            if (this.rootFileLocation == null) {
                throw new SchemaProviderException("Missing root file location for custom schema");
            }
            schemaObject = this.schemaProvider.getSchema(schemaName, this.rootFileLocation, this.schematronFileLocation);
        }
        if (schemaObject == null) {
            throw new SchemaProviderException("Could not find specified schema does not exist");
        }
        return schemaObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validate() {
        LOGGER.debug("Validation started");
        try {
            Schema savedSchema = this.getSchemaByName(this.schema);
            InputSource source = new InputSource();
            source.setByteStream(this.document);
            ValidationResult validationResult = Validator.validate(source, savedSchema.getPath(), savedSchema.getSchematronPath(), this.resolver);
            return validationResult;
        }
        catch (SchemaProviderException e) {
            ValidationResult validationResult = Validator.constructValidationError(null, e);
            return validationResult;
        }
        finally {
            LOGGER.debug("Validation ended");
        }
    }

    private static ValidationResult validate(InputSource source, String schemaPath, String schematronPath, ClasspathResourceResolver resolver) {
        Transformer transformer;
        javax.xml.validation.Validator edmValidator;
        DocumentBuilder edmParser;
        resolver.setPrefix(StringUtils.substringBeforeLast((String)schemaPath, (String)File.separator));
        try {
            edmParser = EDMParser.getInstance().getEdmParser();
            edmValidator = EDMParser.getInstance().getEdmValidator(schemaPath, resolver);
            transformer = StringUtils.isNotEmpty((CharSequence)schematronPath) ? Validator.getTransformer(schematronPath) : null;
        }
        catch (EDMParser.EDMParseSetupException | IOException | TransformerConfigurationException e) {
            LOGGER.error("Problem setting up parsing and validation: {}", (Object)e.getMessage(), (Object)e);
            return Validator.constructValidationError(null, e);
        }
        String rdfAbout = null;
        try {
            Document doc = edmParser.parse(source);
            rdfAbout = Validator.getRdfAbout(doc);
            edmValidator.validate(new DOMSource(doc));
            if (transformer != null) {
                DOMResult result = new DOMResult();
                transformer.transform(new DOMSource(doc), result);
                NodeList nresults = result.getNode().getFirstChild().getChildNodes();
                ValidationResult errorResult = Validator.checkNodeListForErrors(nresults, rdfAbout);
                if (errorResult != null) {
                    return errorResult;
                }
            }
        }
        catch (IOException | TransformerException | SAXException e) {
            return Validator.constructValidationError(rdfAbout, e);
        }
        return Validator.constructOk();
    }

    private static String getRdfAbout(Document document) {
        NodeList nodes = document.getElementsByTagNameNS("http://www.europeana.eu/schemas/edm/", "ProvidedCHO");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Attr aboutAttribute = element.getAttributeNodeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
            String aboutValue = Optional.ofNullable(aboutAttribute).map(Attr::getValue).map(String.class::cast).orElse(null);
            if (aboutValue == null) continue;
            return aboutValue;
        }
        return null;
    }

    private static ValidationResult checkNodeListForErrors(NodeList nresults, String rdfAbout) {
        for (int i = 0; i < nresults.getLength(); ++i) {
            Node nresult = nresults.item(i);
            if (!"failed-assert".equals(nresult.getLocalName())) continue;
            String nodeId = nresult.getAttributes().getNamedItem(NODE_ID_ATTR) == null ? null : nresult.getAttributes().getNamedItem(NODE_ID_ATTR).getTextContent();
            return Validator.constructValidationError(rdfAbout, "Schematron error: " + nresult.getTextContent().trim(), nodeId);
        }
        return null;
    }

    private static Transformer getTransformer(String schematronPath) throws IOException, TransformerConfigurationException {
        if (!templatesCache.containsKey(schematronPath)) {
            StringReader reader = new StringReader(FileUtils.readFileToString((File)new File(schematronPath), (String)StandardCharsets.UTF_8.name()));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Templates template = TransformerFactory.newInstance().newTemplates(new StreamSource(reader));
            templatesCache.put(schematronPath, template);
        }
        return ((Templates)templatesCache.get(schematronPath)).newTransformer();
    }

    private static ValidationResult constructValidationError(String rdfAbout, Exception e) {
        ValidationResult res = new ValidationResult();
        res.setMessage(e.getMessage());
        res.setRecordId(rdfAbout);
        if (StringUtils.isEmpty((CharSequence)res.getRecordId())) {
            res.setRecordId("Missing record identifier for EDM record");
        }
        res.setSuccess(false);
        return res;
    }

    private static ValidationResult constructValidationError(String rdfAbout, String message, String nodeId) {
        ValidationResult res = new ValidationResult();
        res.setMessage(message);
        res.setRecordId(rdfAbout);
        if (StringUtils.isEmpty((CharSequence)res.getRecordId())) {
            res.setRecordId("Missing record identifier for EDM record");
        }
        res.setNodeId(Objects.requireNonNullElse(nodeId, "Missing node identifier"));
        res.setSuccess(false);
        return res;
    }

    private static ValidationResult constructOk() {
        ValidationResult res = new ValidationResult();
        res.setSuccess(true);
        return res;
    }

    @Override
    public ValidationResult call() {
        return this.validate();
    }
}

