/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.model.ValidationResultList;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.PredefinedSchemas;
import eu.europeana.validation.service.PredefinedSchemasGenerator;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.ValidationServiceConfig;
import eu.europeana.validation.service.Validator;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationExecutionService {
    private static final int DEFAULT_THREADS_COUNT = 10;
    private final ClasspathResourceResolver lsResourceResolver;
    private final ExecutorService es;
    private final SchemaProvider schemaProvider;

    @Autowired
    public ValidationExecutionService(ValidationServiceConfig validationServiceConfig, ClasspathResourceResolver lsResourceResolver, SchemaProvider schemaProvider) {
        this.lsResourceResolver = lsResourceResolver;
        this.es = Executors.newFixedThreadPool(validationServiceConfig.getThreadCount());
        this.schemaProvider = schemaProvider;
    }

    public ValidationExecutionService(Properties predefinedSchemasLocations) {
        this(() -> 10, new ClasspathResourceResolver(), ValidationExecutionService.getSchemaProvider(predefinedSchemasLocations));
    }

    private static SchemaProvider getSchemaProvider(Properties predefinedSchemasLocations) {
        PredefinedSchemas predefinedSchemas = PredefinedSchemasGenerator.generate(predefinedSchemasLocations);
        return new SchemaProvider(predefinedSchemas);
    }

    public ValidationResult singleValidation(String schema, String rootFileLocation, String schematronFileLocation, String document) {
        ValidationResult validationResult;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(document.getBytes(StandardCharsets.UTF_8));
        try {
            validationResult = this.singleValidation(schema, rootFileLocation, schematronFileLocation, inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        inputStream.close();
        return validationResult;
    }

    public ValidationResult singleValidation(String schema, String rootFileLocation, String schematronFileLocation, InputStream document) {
        return new Validator(schema, rootFileLocation, schematronFileLocation, document, this.schemaProvider, this.lsResourceResolver).call();
    }

    /*
     * WARNING - void declaration
     */
    public ValidationResultList batchValidation(String schema, String rootFileLocation, String schematronFileLocation, List<? extends InputStream> documents) throws InterruptedException, ExecutionException {
        void var7_9;
        ExecutorCompletionService<ValidationResult> cs = new ExecutorCompletionService<ValidationResult>(this.es);
        for (InputStream inputStream : documents) {
            cs.submit(new Validator(schema, rootFileLocation, schematronFileLocation, inputStream, this.schemaProvider, this.lsResourceResolver));
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean bl = false;
        while (var7_9 < documents.size()) {
            Future future = cs.take();
            ValidationResult res = (ValidationResult)future.get();
            if (!res.isSuccess()) {
                results.add(res);
            }
            ++var7_9;
        }
        ValidationResultList validationResultList = new ValidationResultList();
        validationResultList.setResultList(results);
        if (validationResultList.getResultList().isEmpty()) {
            validationResultList.setSuccess(true);
        }
        return validationResultList;
    }

    @PreDestroy
    public void cleanup() throws IOException {
        if (this.es != null) {
            this.es.shutdown();
        }
        if (this.schemaProvider != null) {
            this.schemaProvider.cleanUp();
        }
    }
}

