/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.Schema;
import eu.europeana.validation.service.PredefinedSchemas;
import eu.europeana.validation.service.SchemaProviderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaProvider.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String ZIP_FILE_NAME = "zip.zip";
    private final String schemasRootDirectory;
    private final HttpClient httpClient = HttpClient.newBuilder().build();
    private final PredefinedSchemas predefinedSchemasLocations;

    public SchemaProvider(PredefinedSchemas predefinedSchemasLocations) {
        String uuidForSchemaProvider = UUID.randomUUID().toString();
        this.schemasRootDirectory = TMP_DIR.endsWith(File.separator) ? TMP_DIR + uuidForSchemaProvider + File.separator : TMP_DIR + File.separator + uuidForSchemaProvider + File.separator;
        LOGGER.info("Creating schema manager. Files will be stored in: {}", (Object)this.schemasRootDirectory);
        this.predefinedSchemasLocations = predefinedSchemasLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema getSchema(String zipUrl, String rootFileLocation, String schematronLocation) throws SchemaProviderException {
        SchemaProvider schemaProvider = this;
        synchronized (schemaProvider) {
            String schemasDirectoryName = this.prepareDirectoryName(zipUrl);
            File downloadedFile = this.downloadZipIfNeeded(zipUrl, schemasDirectoryName);
            this.unzipArchiveIfNeeded(downloadedFile, rootFileLocation);
            return this.prepareSchema(schemasDirectoryName, downloadedFile.getParentFile(), rootFileLocation, schematronLocation);
        }
    }

    public Schema getSchema(String schemaName) throws SchemaProviderException {
        if (this.isPredefined(schemaName)) {
            return this.getSchema(this.predefinedSchemasLocations.get(schemaName).getLocation(), this.predefinedSchemasLocations.get(schemaName).getRootFileLocation(), this.predefinedSchemasLocations.get(schemaName).getSchematronFileLocation());
        }
        throw new SchemaProviderException("XSD root file not provided");
    }

    public String getSchemasDirectory() {
        return this.schemasRootDirectory;
    }

    private String prepareDirectoryName(String name) throws SchemaProviderException {
        try {
            URL url = new URL(name);
            String host = url.getHost();
            String file = url.getFile();
            return host + "_" + StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)file, (String)"."), (String)"/");
        }
        catch (MalformedURLException e) {
            throw new SchemaProviderException(e);
        }
    }

    public boolean isPredefined(String name) {
        return this.predefinedSchemasLocations.contains(name);
    }

    private File downloadZipIfNeeded(String zipLocation, String destinationDir) throws SchemaProviderException {
        HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(zipLocation)).build();
        File schemasLocation = new File(this.schemasRootDirectory, destinationDir);
        if (new File(schemasLocation, ZIP_FILE_NAME).exists()) {
            LOGGER.debug("Zip file will not be downloaded, already exists in temp directory");
            return new File(schemasLocation, ZIP_FILE_NAME);
        }
        if (!schemasLocation.mkdirs() && !schemasLocation.exists()) {
            throw new SchemaProviderException("Unable to create schemaDirecory");
        }
        File destinationFile = new File(schemasLocation, ZIP_FILE_NAME);
        try {
            HttpResponse<Path> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofFile(Paths.get(destinationFile.toURI())));
            destinationFile = httpResponse.body().toFile();
        }
        catch (IOException e) {
            LOGGER.info(String.format("There was some trouble sending a request to %s", schemasLocation), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("The thread was interrupted");
        }
        return destinationFile;
    }

    private void unzipArchiveIfNeeded(File downloadedFile, String rootFileLocation) throws SchemaProviderException {
        if (this.rootFileExists(new File(downloadedFile.getParent()), rootFileLocation)) {
            LOGGER.debug("Archive will not be unzipped.");
        } else {
            this.unzipArchive(downloadedFile);
        }
    }

    private void unzipArchive(File downloadedFile) throws SchemaProviderException {
        try (ZipFile zipFile = new ZipFile(downloadedFile);){
            Iterator entries = zipFile.stream().iterator();
            while (entries.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)entries.next();
                this.handleZipEntry(downloadedFile, zipFile, zipEntry);
            }
        }
        catch (IOException e) {
            throw new SchemaProviderException("Exception while unzipping file", e);
        }
    }

    private void handleZipEntry(File downloadedFile, ZipFile zip, ZipEntry entry) throws SchemaProviderException, IOException {
        File fileLocation = new File(downloadedFile.getParent(), entry.getName());
        if (!fileLocation.getCanonicalPath().startsWith(downloadedFile.getCanonicalFile().getParent())) {
            throw new IOException("Entry is outside of the target directory");
        }
        if (entry.isDirectory()) {
            boolean couldCreateDir = fileLocation.mkdir();
            if (!couldCreateDir) {
                throw new SchemaProviderException("Could not create directory");
            }
        } else {
            InputStream zipStream = zip.getInputStream(entry);
            FileUtils.copyInputStreamToFile((InputStream)zipStream, (File)fileLocation);
        }
    }

    private Schema prepareSchema(String schemaName, File unzippedSchemaLocation, String rootFileLocation, String schematronLocation) throws SchemaProviderException {
        Schema schema = new Schema();
        schema.setName(schemaName);
        if (this.rootFileExists(unzippedSchemaLocation, rootFileLocation)) {
            schema.setPath(unzippedSchemaLocation.getAbsolutePath() + File.separator + rootFileLocation);
            if (schematronLocation != null) {
                schema.setSchematronPath(unzippedSchemaLocation.getAbsolutePath() + File.separator + schematronLocation);
            }
            return schema;
        }
        throw new SchemaProviderException("Provided root xsd file does not exist in archive");
    }

    private boolean rootFileExists(File unzippedSchemaLocation, String rootFileLocation) {
        File rootFile = new File(unzippedSchemaLocation, rootFileLocation);
        return rootFile.exists();
    }

    public void cleanUp() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.schemasRootDirectory));
    }
}

