/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.service.ClasspathLSInput;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ClasspathResourceResolver
implements LSResourceResolver {
    private String prefix;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResourceResolver.class);

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            String fullPath = new File(this.prefix, systemId).getAbsolutePath();
            byte[] bytes = Files.readAllBytes(Paths.get(fullPath, new String[0]));
            String fileContent = new String(bytes, StandardCharsets.UTF_8.name());
            StringReader stringReader = new StringReader(fileContent);
            ClasspathLSInput input = new ClasspathLSInput();
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setBaseURI(baseURI);
            input.setCharacterStream(stringReader);
            return input;
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while resolving a resource", (Throwable)e);
            return null;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

