/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.Schema;
import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.EDMParser;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.SchemaProviderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator
implements Callable<ValidationResult> {
    private static final String NODE_ID_ATTR = "nodeId";
    private static final Logger LOGGER = LoggerFactory.getLogger(Validator.class);
    private static ConcurrentMap<String, Templates> templatesCache = new ConcurrentHashMap<String, Templates>();
    private final String schema;
    private final String rootFileLocation;
    private final String schematronFileLocation;
    private final InputStream document;
    private final SchemaProvider schemaProvider;
    private final ClasspathResourceResolver resolver;

    public Validator(String schema, String rootFileLocation, String schematronFileLocation, InputStream document, SchemaProvider schemaProvider, ClasspathResourceResolver resolver) {
        this.schema = schema;
        this.rootFileLocation = rootFileLocation;
        this.schematronFileLocation = schematronFileLocation;
        this.document = document;
        this.schemaProvider = schemaProvider;
        this.resolver = resolver;
    }

    private Schema getSchemaByName(String schemaName) throws SchemaProviderException {
        Schema schemaObject;
        if (this.schemaProvider.isPredefined(schemaName)) {
            schemaObject = this.schemaProvider.getSchema(schemaName);
        } else {
            if (this.rootFileLocation == null) {
                throw new SchemaProviderException("Missing root file location for custom schema");
            }
            schemaObject = this.schemaProvider.getSchema(schemaName, this.rootFileLocation, this.schematronFileLocation);
        }
        if (schemaObject == null) {
            throw new SchemaProviderException("Could not find specified schema does not exist");
        }
        return schemaObject;
    }

    private ValidationResult validate() {
        LOGGER.debug("Validation started");
        InputSource source = new InputSource();
        source.setByteStream(this.document);
        String rdfAbout = null;
        try {
            Schema savedSchema = this.getSchemaByName(this.schema);
            this.resolver.setPrefix(StringUtils.substringBeforeLast((String)savedSchema.getPath(), (String)File.separator));
            Document doc = EDMParser.getInstance().getEdmParser().parse(source);
            rdfAbout = this.getRdfAbout(doc);
            EDMParser.getInstance().getEdmValidator(savedSchema.getPath(), this.resolver).validate(new DOMSource(doc));
            if (StringUtils.isNotEmpty((CharSequence)savedSchema.getSchematronPath())) {
                Transformer transformer = this.getTransformer(savedSchema);
                DOMResult result = new DOMResult();
                transformer.transform(new DOMSource(doc), result);
                NodeList nresults = result.getNode().getFirstChild().getChildNodes();
                ValidationResult errorResult = this.checkNodeListForErrors(nresults, rdfAbout);
                if (errorResult != null) {
                    return errorResult;
                }
            }
        }
        catch (SchemaProviderException | IOException | TransformerException | SAXException e) {
            return this.constructValidationError(rdfAbout, e);
        }
        LOGGER.debug("Validation ended");
        return this.constructOk();
    }

    private String getRdfAbout(Document document) {
        NodeList nodes = document.getElementsByTagNameNS("http://www.europeana.eu/schemas/edm/", "ProvidedCHO");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Attr aboutAttribute = element.getAttributeNodeNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
            String aboutValue = Optional.ofNullable(aboutAttribute).map(Attr::getValue).map(String.class::cast).orElse(null);
            if (aboutValue == null) continue;
            return aboutValue;
        }
        return null;
    }

    private ValidationResult checkNodeListForErrors(NodeList nresults, String rdfAbout) {
        for (int i = 0; i < nresults.getLength(); ++i) {
            Node nresult = nresults.item(i);
            if (!"failed-assert".equals(nresult.getLocalName())) continue;
            String nodeId = nresult.getAttributes().getNamedItem(NODE_ID_ATTR) == null ? null : nresult.getAttributes().getNamedItem(NODE_ID_ATTR).getTextContent();
            return this.constructValidationError(rdfAbout, "Schematron error: " + nresult.getTextContent().trim(), nodeId);
        }
        return null;
    }

    private Transformer getTransformer(Schema schema) throws IOException, TransformerConfigurationException {
        String schematronPath = schema.getSchematronPath();
        if (!templatesCache.containsKey(schematronPath)) {
            StringReader reader = new StringReader(FileUtils.readFileToString((File)new File(schematronPath), (String)StandardCharsets.UTF_8.name()));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Templates template = TransformerFactory.newInstance().newTemplates(new StreamSource(reader));
            templatesCache.put(schematronPath, template);
        }
        return ((Templates)templatesCache.get(schematronPath)).newTransformer();
    }

    private ValidationResult constructValidationError(String rdfAbout, Exception e) {
        ValidationResult res = new ValidationResult();
        res.setMessage(e.getMessage());
        res.setRecordId(rdfAbout);
        if (StringUtils.isEmpty((CharSequence)res.getRecordId())) {
            res.setRecordId("Missing record identifier for EDM record");
        }
        res.setSuccess(false);
        return res;
    }

    private ValidationResult constructValidationError(String rdfAbout, String message, String nodeId) {
        ValidationResult res = new ValidationResult();
        res.setMessage(message);
        res.setRecordId(rdfAbout);
        if (StringUtils.isEmpty((CharSequence)res.getRecordId())) {
            res.setRecordId("Missing record identifier for EDM record");
        }
        if (nodeId == null) {
            res.setNodeId("Missing node identifier");
        } else {
            res.setNodeId(nodeId);
        }
        res.setSuccess(false);
        return res;
    }

    private ValidationResult constructOk() {
        ValidationResult res = new ValidationResult();
        res.setSuccess(true);
        return res;
    }

    @Override
    public ValidationResult call() {
        return this.validate();
    }
}

