/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.Schema;
import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.EDMParser;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.SchemaProviderException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Validator
implements Callable<ValidationResult> {
    private static final String NODE_ID_ATTR = "nodeId";
    private static final Logger LOGGER = LoggerFactory.getLogger(Validator.class);
    private static ConcurrentMap<String, Templates> templatesCache = new ConcurrentHashMap<String, Templates>();
    private final String schema;
    private final String rootFileLocation;
    private final String schematronFileLocation;
    private final String document;
    private final SchemaProvider schemaProvider;
    private final ClasspathResourceResolver resolver;

    public Validator(String schema, String rootFileLocation, String schematronFileLocation, String document, SchemaProvider schemaProvider, ClasspathResourceResolver resolver) {
        this.schema = schema;
        this.rootFileLocation = rootFileLocation;
        this.schematronFileLocation = schematronFileLocation;
        this.document = document;
        this.schemaProvider = schemaProvider;
        this.resolver = resolver;
    }

    private Schema getSchemaByName(String schemaName) throws SchemaProviderException {
        Schema schemaObject;
        if (this.schemaProvider.isPredefined(schemaName)) {
            schemaObject = this.schemaProvider.getSchema(schemaName);
        } else {
            if (this.rootFileLocation == null) {
                throw new SchemaProviderException("Missing root file location for custom schema");
            }
            schemaObject = this.schemaProvider.getSchema(schemaName, this.rootFileLocation, this.schematronFileLocation);
        }
        if (schemaObject == null) {
            throw new SchemaProviderException("Could not find specified schema does not exist");
        }
        return schemaObject;
    }

    private ValidationResult validate() {
        LOGGER.debug("Validation started");
        InputSource source = new InputSource();
        source.setByteStream(new ByteArrayInputStream(this.document.getBytes(StandardCharsets.UTF_8)));
        try {
            Schema savedSchema = this.getSchemaByName(this.schema);
            this.resolver.setPrefix(StringUtils.substringBeforeLast((String)savedSchema.getPath(), (String)File.separator));
            Document doc = EDMParser.getInstance().getEdmParser().parse(source);
            EDMParser.getInstance().getEdmValidator(savedSchema.getPath(), this.resolver).validate(new DOMSource(doc));
            if (StringUtils.isNotEmpty((CharSequence)savedSchema.getSchematronPath())) {
                Transformer transformer = this.getTransformer(savedSchema);
                DOMResult result = new DOMResult();
                transformer.transform(new DOMSource(doc), result);
                NodeList nresults = result.getNode().getFirstChild().getChildNodes();
                ValidationResult errorResult = this.checkNodeListForErrors(nresults);
                if (errorResult != null) {
                    return errorResult;
                }
            }
        }
        catch (SchemaProviderException | IOException | TransformerException | SAXException e) {
            return this.constructValidationError(this.document, e);
        }
        LOGGER.debug("Validation ended");
        return this.constructOk();
    }

    private ValidationResult checkNodeListForErrors(NodeList nresults) {
        for (int i = 0; i < nresults.getLength(); ++i) {
            Node nresult = nresults.item(i);
            if (!"failed-assert".equals(nresult.getLocalName())) continue;
            String nodeId = nresult.getAttributes().getNamedItem(NODE_ID_ATTR) == null ? null : nresult.getAttributes().getNamedItem(NODE_ID_ATTR).getTextContent();
            return this.constructValidationError(this.document, "Schematron error: " + nresult.getTextContent().trim(), nodeId);
        }
        return null;
    }

    private Transformer getTransformer(Schema schema) throws IOException, TransformerConfigurationException {
        String schematronPath = schema.getSchematronPath();
        if (!templatesCache.containsKey(schematronPath)) {
            StringReader reader = new StringReader(FileUtils.readFileToString((File)new File(schematronPath), (String)StandardCharsets.UTF_8.name()));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Templates template = TransformerFactory.newInstance().newTemplates(new StreamSource(reader));
            templatesCache.put(schematronPath, template);
        }
        return ((Templates)templatesCache.get(schematronPath)).newTransformer();
    }

    private ValidationResult constructValidationError(String document, Exception e) {
        ValidationResult res = new ValidationResult();
        res.setMessage(e.getMessage());
        res.setRecordId(this.getRecordId(document));
        if (StringUtils.isEmpty((CharSequence)res.getRecordId())) {
            res.setRecordId("Missing record identifier for EDM record");
        }
        res.setSuccess(false);
        return res;
    }

    private ValidationResult constructValidationError(String document, String message, String nodeId) {
        ValidationResult res = new ValidationResult();
        res.setMessage(message);
        res.setRecordId(this.getRecordId(document));
        if (StringUtils.isEmpty((CharSequence)res.getRecordId())) {
            res.setRecordId("Missing record identifier for EDM record");
        }
        if (nodeId == null) {
            res.setNodeId("Missing node identifier");
        } else {
            res.setNodeId(nodeId);
        }
        res.setSuccess(false);
        return res;
    }

    private String getRecordId(String document) {
        Pattern pattern = Pattern.compile("ProvidedCHO\\s+rdf:about\\s?=\\s?\"(.+)\"\\s?>");
        Matcher matcher = pattern.matcher(document);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private ValidationResult constructOk() {
        ValidationResult res = new ValidationResult();
        res.setSuccess(true);
        return res;
    }

    @Override
    public ValidationResult call() {
        return this.validate();
    }
}

