/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.model.ValidationResultList;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.PredefinedSchemas;
import eu.europeana.validation.service.PredefinedSchemasGenerator;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.ValidationServiceConfig;
import eu.europeana.validation.service.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationExecutionService {
    private final ClasspathResourceResolver lsResourceResolver;
    private final ExecutorService es;
    private final SchemaProvider schemaProvider;
    private static final int DEFAULT_THREADS_COUNT = 10;

    @Autowired
    public ValidationExecutionService(ValidationServiceConfig validationServiceConfig, ClasspathResourceResolver lsResourceResolver, SchemaProvider schemaProvider) {
        this.lsResourceResolver = lsResourceResolver;
        this.es = Executors.newFixedThreadPool(validationServiceConfig.getThreadCount());
        this.schemaProvider = schemaProvider;
    }

    public ValidationExecutionService(Properties predefinedSchemasLocations) {
        this(() -> 10, new ClasspathResourceResolver(), ValidationExecutionService.getSchemaProvider(predefinedSchemasLocations));
    }

    private static SchemaProvider getSchemaProvider(Properties predefinedSchemasLocations) {
        PredefinedSchemas predefinedSchemas = PredefinedSchemasGenerator.generate(predefinedSchemasLocations);
        return new SchemaProvider(predefinedSchemas);
    }

    public ValidationResult singleValidation(String schema, String rootFileLocation, String schematronFileLocation, String document) {
        return new Validator(schema, rootFileLocation, schematronFileLocation, document, this.schemaProvider, this.lsResourceResolver).call();
    }

    public ValidationResultList batchValidation(String schema, String rootFileLocation, String schematronFileLocation, List<String> documents) throws InterruptedException, ExecutionException {
        ExecutorCompletionService<ValidationResult> cs = new ExecutorCompletionService<ValidationResult>(this.es);
        for (String document : documents) {
            cs.submit(new Validator(schema, rootFileLocation, schematronFileLocation, document, this.schemaProvider, this.lsResourceResolver));
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (int i = 0; i < documents.size(); ++i) {
            Future future = cs.take();
            ValidationResult res = (ValidationResult)future.get();
            if (res.isSuccess()) continue;
            results.add(res);
        }
        ValidationResultList resultList = new ValidationResultList();
        resultList.setResultList(results);
        if (resultList.getResultList().isEmpty()) {
            resultList.setSuccess(true);
        }
        return resultList;
    }

    @PreDestroy
    void cleanup() throws IOException {
        if (this.es != null) {
            this.es.shutdown();
        }
        if (this.schemaProvider != null) {
            this.schemaProvider.cleanUp();
        }
    }
}

