/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.model.ValidationResultList;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.PredefinedSchemas;
import eu.europeana.validation.service.PredefinedSchemasGenerator;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.ValidationServiceConfig;
import eu.europeana.validation.service.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationExecutionService {
    private final ClasspathResourceResolver lsResourceResolver;
    private final ExecutorService es;
    public static final int DEFAULT_THREADS_COUNT = 10;
    @Autowired
    private SchemaProvider schemaProvider;

    @Autowired
    public ValidationExecutionService(ValidationServiceConfig config, ClasspathResourceResolver lsResourceResolver) {
        this.lsResourceResolver = lsResourceResolver;
        this.es = Executors.newFixedThreadPool(config.getThreadCount());
    }

    public ValidationExecutionService(ValidationServiceConfig config, ClasspathResourceResolver lsResourceResolver, SchemaProvider schemaProvider) {
        this(config, lsResourceResolver);
        this.schemaProvider = schemaProvider;
    }

    public ValidationExecutionService(Properties predefinedSchemasLocations) {
        this(() -> 10, new ClasspathResourceResolver());
        this.schemaProvider = this.getSchemaProvider(predefinedSchemasLocations);
    }

    private SchemaProvider getSchemaProvider(Properties predefinedSchemasLocations) {
        PredefinedSchemas predefinedSchemas = PredefinedSchemasGenerator.generate(predefinedSchemasLocations);
        return new SchemaProvider(predefinedSchemas);
    }

    public ValidationResult singleValidation(String schema, String rootFileLocation, String schematronFileLocation, String document) {
        return new Validator(schema, rootFileLocation, schematronFileLocation, document, this.schemaProvider, this.lsResourceResolver).call();
    }

    public ValidationResultList batchValidation(String schema, String rootFileLocation, String schematronFileLocation, List<String> documents) throws InterruptedException, ExecutionException {
        ExecutorCompletionService<ValidationResult> cs = new ExecutorCompletionService<ValidationResult>(this.es);
        for (String document : documents) {
            cs.submit(new Validator(schema, rootFileLocation, schematronFileLocation, document, this.schemaProvider, this.lsResourceResolver));
        }
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (int i = 0; i < documents.size(); ++i) {
            Future future = cs.take();
            ValidationResult res = (ValidationResult)future.get();
            if (res.isSuccess()) continue;
            results.add(res);
        }
        ValidationResultList resultList = new ValidationResultList();
        resultList.setResultList(results);
        if (resultList.getResultList().isEmpty()) {
            resultList.setSuccess(true);
        }
        return resultList;
    }

    @PreDestroy
    void cleanup() {
        if (this.es != null) {
            this.es.shutdown();
        }
    }
}

