/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.service.ClasspathLSInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ClasspathResourceResolver
implements LSResourceResolver {
    private String prefix;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathResourceResolver.class);
    private static Map<String, InputStream> cache = new HashMap<String, InputStream>();

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        try {
            InputStream stream;
            ClasspathLSInput input = new ClasspathLSInput();
            if (systemId.startsWith("http")) {
                if (cache.get(systemId) == null) {
                    stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("xml.xsd");
                    cache.put(systemId, stream);
                } else {
                    stream = cache.get(systemId);
                }
            } else {
                String fullPath = new File(this.prefix, systemId).getAbsolutePath();
                if (cache.get(fullPath) == null) {
                    stream = Files.newInputStream(Paths.get(fullPath, new String[0]), new OpenOption[0]);
                    cache.put(systemId, stream);
                } else {
                    stream = cache.get(fullPath);
                }
            }
            input.setPublicId(publicId);
            input.setSystemId(systemId);
            input.setBaseURI(baseURI);
            input.setCharacterStream(new InputStreamReader(stream, StandardCharsets.UTF_8.name()));
            return input;
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while resolving a resource", (Throwable)e);
            return null;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

