/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.service;

import eu.europeana.validation.model.Schema;
import eu.europeana.validation.service.PredefinedSchemas;
import eu.europeana.validation.service.SchemaProviderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaProvider.class);
    public static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String ZIP_FILE_NAME = "zip.zip";
    private String schemasDir = TMP_DIR.endsWith(File.separator) ? TMP_DIR + "schemas" + File.separator : TMP_DIR + File.separator + "schemas" + File.separator;
    private final PredefinedSchemas predefinedSchemasLocations;

    public SchemaProvider(PredefinedSchemas predefinedSchemasLocations) {
        LOGGER.info("Creating schema manager. Files will be stored in: {}", (Object)this.schemasDir);
        this.predefinedSchemasLocations = predefinedSchemasLocations;
    }

    public synchronized Schema getSchema(String fileLocation, String rootFileLocation, String schematronLocation) throws SchemaProviderException {
        File downloadedFile = this.downloadZipIfNeeded(fileLocation, this.prepareDirectoryName(fileLocation));
        this.unzipArchiveIfNeeded(downloadedFile, rootFileLocation);
        return this.prepareSchema(this.prepareDirectoryName(fileLocation), downloadedFile.getParentFile(), rootFileLocation, schematronLocation);
    }

    public Schema getSchema(String fileLocation) throws SchemaProviderException {
        if (this.isPredefined(fileLocation)) {
            return this.getSchema(this.predefinedSchemasLocations.get(fileLocation).getLocation(), this.predefinedSchemasLocations.get(fileLocation).getRootFileLocation(), this.predefinedSchemasLocations.get(fileLocation).getSchematronFileLocation());
        }
        throw new SchemaProviderException("XSD root file not provided");
    }

    public String getSchemasDirectory() {
        return this.schemasDir;
    }

    private String prepareDirectoryName(String name) throws SchemaProviderException {
        try {
            URL url = new URL(name);
            String host = url.getHost();
            String file = url.getFile();
            return host + "_" + StringUtils.substringAfter((String)StringUtils.substringBeforeLast((String)file, (String)"."), (String)"/");
        }
        catch (MalformedURLException e) {
            throw new SchemaProviderException(e);
        }
    }

    public boolean isPredefined(String name) {
        return this.predefinedSchemasLocations.contains(name);
    }

    /*
     * Exception decompiling
     */
    private File downloadZipIfNeeded(String zipLocation, String destinationDir) throws SchemaProviderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void unzipArchiveIfNeeded(File downloadedFile, String rootFileLocation) throws SchemaProviderException {
        if (this.rootFileExists(new File(downloadedFile.getParent()), rootFileLocation)) {
            LOGGER.debug("Archive will not be unzipped.");
        } else {
            this.unzipArchive(downloadedFile);
        }
    }

    private void unzipArchive(File downloadedFile) throws SchemaProviderException {
        try (ZipFile zip = new ZipFile(downloadedFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    new File(downloadedFile.getAbsolutePath()).mkdir();
                    continue;
                }
                InputStream zipStream = zip.getInputStream(entry);
                FileUtils.copyInputStreamToFile((InputStream)zipStream, (File)new File(downloadedFile.getParent(), entry.getName()));
            }
        }
        catch (IOException e) {
            throw new SchemaProviderException("Exception while unzipping file", e);
        }
    }

    private Schema prepareSchema(String schemaName, File unzippedSchemaLocation, String rootFileLocation, String schematronLocation) throws SchemaProviderException {
        Schema schema = new Schema();
        schema.setName(schemaName);
        if (this.rootFileExists(unzippedSchemaLocation, rootFileLocation)) {
            schema.setPath(unzippedSchemaLocation.getAbsolutePath() + File.separator + rootFileLocation);
            if (schematronLocation != null) {
                schema.setSchematronPath(unzippedSchemaLocation.getAbsolutePath() + File.separator + schematronLocation);
            }
            return schema;
        }
        throw new SchemaProviderException("Provided root xsd file does not exist in archive");
    }

    private boolean rootFileExists(File unzippedSchemaLocation, String rootFileLocation) {
        File rootFile = new File(unzippedSchemaLocation, rootFileLocation);
        return rootFile.exists();
    }
}

