/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.rest;

import eu.europeana.metis.utils.ZipFileReader;
import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.model.ValidationResultList;
import eu.europeana.validation.rest.exceptions.BatchValidationException;
import eu.europeana.validation.rest.exceptions.ServerException;
import eu.europeana.validation.rest.exceptions.ValidationException;
import eu.europeana.validation.service.SchemaProvider;
import eu.europeana.validation.service.ValidationExecutionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Api(value="/")
public class ValidationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationController.class);
    private final ValidationExecutionService validator;
    private final SchemaProvider schemaProvider;

    @Autowired
    public ValidationController(ValidationExecutionService validationExecutionService, SchemaProvider schemaProvider) {
        this.validator = validationExecutionService;
        this.schemaProvider = schemaProvider;
    }

    @PostMapping(value={"/schema/validate/{schema}"}, consumes={"application/xml"}, produces={"application/json"})
    @ResponseBody
    @ApiOperation(value="Validate single record based on schema", response=ValidationResult.class)
    public ValidationResult validate(@ApiParam(value="schema") @PathVariable(value="schema") String targetSchema, @RequestBody String record) throws ValidationException {
        if (!this.schemaProvider.isPredefined(targetSchema)) {
            throw new ValidationException("", "", "It is not predefined schema.");
        }
        ValidationResult result = this.validator.singleValidation(targetSchema, null, null, record);
        if (result.isSuccess()) {
            return result;
        }
        LOGGER.error(result.getMessage());
        throw new ValidationException(result.getRecordId(), result.getNodeId(), result.getMessage());
    }

    @PostMapping(value={"/schema/validate/batch/{schema}"})
    @ResponseBody
    @ApiOperation(value="Validate zip file based on schema", response=ValidationResultList.class)
    public ValidationResultList batchValidate(@ApiParam(value="schema") @PathVariable(value="schema") String targetSchema, @ApiParam(value="file") @RequestParam(value="file") MultipartFile providedZipFile) throws ServerException, BatchValidationException {
        List records;
        if (!this.schemaProvider.isPredefined(targetSchema)) {
            throw new BatchValidationException("It is not predefined schema.", new ValidationResultList());
        }
        try {
            records = new ZipFileReader().getContentFromZipFile(providedZipFile.getInputStream());
        }
        catch (IOException e) {
            throw new ServerException((Throwable)e);
        }
        if (records.isEmpty()) {
            throw new ServerException("No suitable records found in zip file.");
        }
        try {
            ValidationResultList list = this.validator.batchValidation(targetSchema, null, null, records);
            if (list.getResultList() != null || list.getResultList().isEmpty()) {
                list.setSuccess(true);
            }
            if (list.isSuccess()) {
                return list;
            }
            throw new BatchValidationException("Batch service failed", list);
        }
        catch (ExecutionException e) {
            throw new ServerException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServerException((Throwable)e);
        }
    }
}

