/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.rest.config;

import eu.europeana.validation.service.ValidationServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@Service
@PropertySource(value={"classpath:validation.properties"})
public class ValidationServiceConfigImpl
implements ValidationServiceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationServiceConfigImpl.class);
    private static final int DEFAULT_THREADS_COUNT = 10;
    @Value(value="${validation.executor.threadCount:10}")
    private String executorThreadCount;

    public int getThreadCount() {
        try {
            int value = Integer.parseInt(this.executorThreadCount);
            LOGGER.info("Using validation.executor.threadCount with value {}", (Object)value);
            return value;
        }
        catch (NumberFormatException ex) {
            LOGGER.warn("Failed to parse validation.executor.threadCount with value '{}'. Taking 10 as default", (Object)this.executorThreadCount);
            return 10;
        }
    }
}

