/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.rest.config;

import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.validation.service.ClasspathResourceResolver;
import eu.europeana.validation.service.PredefinedSchemas;
import eu.europeana.validation.service.PredefinedSchemasGenerator;
import eu.europeana.validation.service.SchemaProvider;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@ComponentScan(basePackages={"eu.europeana.validation.rest", "eu.europeana.validation.rest.exceptions.exceptionmappers"})
@PropertySource(value={"classpath:validation.properties"})
@EnableWebMvc
@EnableSwagger2
@Configuration
public class Application
implements WebMvcConfigurer,
InitializingBean {
    public static final int MAX_UPLOAD_SIZE = 50000000;
    @Value(value="${socks.proxy.enabled}")
    private boolean socksProxyEnabled;
    @Value(value="${socks.proxy.host}")
    private String socksProxyHost;
    @Value(value="${socks.proxy.port}")
    private String socksProxyPort;
    @Value(value="${socks.proxy.username}")
    private String socksProxyUsername;
    @Value(value="${socks.proxy.password}")
    private String socksProxyPassword;
    @Resource(name="validationProperties")
    private Properties predefinedSchemasLocations;

    public void afterPropertiesSet() {
        if (this.socksProxyEnabled) {
            new SocksProxy(this.socksProxyHost, this.socksProxyPort, this.socksProxyUsername, this.socksProxyPassword).init();
        }
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "swagger-ui.html");
    }

    @Bean(name={"validationProperties"})
    PropertiesFactoryBean mapper() {
        PropertiesFactoryBean bean = new PropertiesFactoryBean();
        bean.setLocation((org.springframework.core.io.Resource)new ClassPathResource("validation.properties"));
        return bean;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    public CommonsMultipartResolver multipartResolver() {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver();
        commonsMultipartResolver.setDefaultEncoding("utf-8");
        commonsMultipartResolver.setMaxUploadSize(50000000L);
        return commonsMultipartResolver;
    }

    @Bean
    public SchemaProvider schemaManager() {
        PredefinedSchemas predefinedSchemas = PredefinedSchemasGenerator.generate((Properties)this.predefinedSchemasLocations);
        return new SchemaProvider(predefinedSchemas);
    }

    @Bean
    public ClasspathResourceResolver getLSResourceResolver() {
        return new ClasspathResourceResolver();
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/.*")).build().apiInfo(this.apiInfo());
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Validation REST API", "Validation REST API for Europeana", "v1", "API TOS", new Contact("Europeana", "europeana.eu", "development@europeana.eu"), "EUPL Licence v1.1", "");
    }
}

