/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.validation.client;

import eu.europeana.metis.RestEndpoints;
import eu.europeana.validation.client.ValidationResponseHandler;
import eu.europeana.validation.model.ValidationResult;
import eu.europeana.validation.model.ValidationResultList;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class ValidationClient {
    private final RestTemplate template = new RestTemplate();
    private String validationEndpoint;

    public ValidationClient() throws IOException {
        Properties props = new Properties();
        this.template.setErrorHandler((ResponseErrorHandler)new ValidationResponseHandler());
        props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("validation.properties"));
        this.validationEndpoint = props.getProperty("validation.endpoint");
    }

    public ValidationClient(String validationEndpoint) {
        this.validationEndpoint = validationEndpoint;
        this.template.setErrorHandler((ResponseErrorHandler)new ValidationResponseHandler());
    }

    public ValidationResult validateRecord(String schemaName, String record) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity entity = new HttpEntity((Object)record, (MultiValueMap)headers);
        return (ValidationResult)this.template.postForEntity(this.validationEndpoint + RestEndpoints.resolve((String)"/schema/validate/{schema}", Collections.singletonList(schemaName)), (Object)entity, ValidationResult.class, new Object[0]).getBody();
    }

    public ValidationResultList validateRecordsInFile(String schemaName, File file) {
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        parts.add((Object)"file", (Object)new FileSystemResource(file));
        return (ValidationResultList)this.template.postForObject(this.validationEndpoint + RestEndpoints.resolve((String)"/schema/validate/batch/{schema}", Collections.singletonList(schemaName)), (Object)parts, ValidationResultList.class, new Object[0]);
    }
}

