/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.transformation.service;

import eu.europeana.metis.schema.jibx.AboutType;
import eu.europeana.metis.schema.jibx.RDF;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.EuropeanaIdException;
import eu.europeana.metis.utils.RdfNamespaceContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class EuropeanaIdCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EuropeanaIdCreator.class);
    private static final int EVALUATE_XPATH_ATTEMPT_COUNT = 20;
    private static final int EVALUATE_XPATH_ATTEMPT_INTERVAL_IN_MS = 50;
    private static final String RDF_ABOUT_EXPRESSION = String.format("/%s:RDF/%s:ProvidedCHO[1]/@%s:about", "rdf", "edm", "rdf");
    private static final Pattern LEGACY_COLLECTION_ID_PATTERN = Pattern.compile("[a-zA-Z]");
    private static final Pattern LEGACY_RDF_ABOUT_REPLACE_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String REPLACEMENT_CHARACTER = "_";
    private static final Supplier<EuropeanaIdException> ID_NOT_FOUND_EXCEPTION_SUPPLIER = () -> new EuropeanaIdException("Could not find provider ID in source.");
    private final XPathExpression rdfAboutExtractor;
    private DocumentBuilder builder;

    public EuropeanaIdCreator() throws EuropeanaIdException {
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            df.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            df.setNamespaceAware(true);
            this.builder = df.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new EuropeanaIdException("Something went wrong while setting up the document builder.", e);
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)new RdfNamespaceContext());
        try {
            this.rdfAboutExtractor = xpath.compile(RDF_ABOUT_EXPRESSION);
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Something went wrong while setting up the xpath.", (Throwable)e);
            throw new EuropeanaIdException("Something went wrong while setting up the xpath.", e);
        }
    }

    public EuropeanaGeneratedIdsMap constructEuropeanaId(RDF rdf, String datasetId) throws EuropeanaIdException {
        return this.constructEuropeanaIdInternal(this.extractRdfAboutFromRdf(rdf), datasetId);
    }

    public EuropeanaGeneratedIdsMap constructEuropeanaId(String rdfString, String datasetId) throws EuropeanaIdException {
        return this.constructEuropeanaIdInternal(this.extractRdfAboutFromRdfString(rdfString), datasetId);
    }

    public EuropeanaGeneratedIdsMap constructEuropeanaId(InputStream inputStream, String datasetId) throws EuropeanaIdException {
        return this.constructEuropeanaIdInternal(this.extractRdfAboutFromInputStream(inputStream), datasetId);
    }

    private EuropeanaGeneratedIdsMap constructEuropeanaIdInternal(String rdfAbout, String datasetId) {
        String europeanaId = "/" + EuropeanaIdCreator.sanitizeDatasetIdLegacy(datasetId) + "/" + EuropeanaIdCreator.sanitizeRdfAboutLegacy(rdfAbout);
        return new EuropeanaGeneratedIdsMap(rdfAbout, europeanaId);
    }

    private static String sanitizeRdfAboutLegacy(String rdfAbout) {
        String recordId = rdfAbout.startsWith("http://") ? EuropeanaIdCreator.substringAfterLegacy(EuropeanaIdCreator.substringAfterLegacy(rdfAbout, "http://"), "/") : rdfAbout;
        Matcher matcher = LEGACY_RDF_ABOUT_REPLACE_PATTERN.matcher(recordId);
        return matcher.replaceAll(REPLACEMENT_CHARACTER);
    }

    private static String substringAfterLegacy(String str, String separator) {
        int pos = str.indexOf(separator);
        if (pos < 0) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    private static String sanitizeDatasetIdLegacy(String collectionId) {
        Matcher matcher = LEGACY_COLLECTION_ID_PATTERN.matcher(collectionId.substring(collectionId.length() - 1, collectionId.length()));
        return matcher.find() ? collectionId.substring(0, collectionId.length() - 1) : collectionId;
    }

    private String extractRdfAboutFromRdf(RDF rdf) throws EuropeanaIdException {
        String result = rdf.getProvidedCHOList().stream().filter(Objects::nonNull).findFirst().map(AboutType::getAbout).orElse(null);
        if (StringUtils.isBlank((CharSequence)result)) {
            throw ID_NOT_FOUND_EXCEPTION_SUPPLIER.get();
        }
        return result;
    }

    private String extractRdfAboutFromRdfString(String rdfString) throws EuropeanaIdException {
        String string;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(rdfString.getBytes(StandardCharsets.UTF_8));
        try {
            string = this.extractRdfAboutFromInputStream(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new EuropeanaIdException("Something went wrong while extracting the provider ID from the source.", e);
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }

    private String extractRdfAboutFromInputStream(InputStream inputStream) throws EuropeanaIdException {
        String result;
        try {
            result = this.extractRdfAboutFromInputStreamInternal(inputStream);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted.");
            Thread.currentThread().interrupt();
            return null;
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            throw ID_NOT_FOUND_EXCEPTION_SUPPLIER.get();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String extractRdfAboutFromInputStreamInternal(InputStream inputStream) throws EuropeanaIdException, InterruptedException {
        Exception xpathException = null;
        int i = 0;
        while (i < 20) {
            if (i > 0) {
                Thread.sleep(50L);
            }
            Class<EuropeanaIdCreator> clazz = EuropeanaIdCreator.class;
            // MONITORENTER : eu.europeana.metis.transformation.service.EuropeanaIdCreator.class
            try {
                // MONITOREXIT : clazz
                return this.rdfAboutExtractor.evaluate(this.builder.parse(inputStream));
            }
            catch (IOException | XPathExpressionException | SAXException e) {
                if (!EuropeanaIdCreator.isRaceCondition(e)) throw new EuropeanaIdException("Something went wrong while extracting the provider ID from the source.", e);
                LOGGER.warn("Race condition error occurred during attempt {} of {}. Trying again...", new Object[]{i, 20, e});
                xpathException = e;
                // MONITOREXIT : clazz
                ++i;
            }
        }
        throw new EuropeanaIdException("Last XPath evaluation attempt generated exception.", xpathException);
    }

    private static boolean isRaceCondition(Exception exception) {
        if (exception.getMessage() != null && exception.getMessage().contains("FWK005 parse may not be called while parsing")) {
            return true;
        }
        if (exception.getCause() instanceof NullPointerException) {
            StackTraceElement[] stackTrace = exception.getCause().getStackTrace();
            StackTraceElement firstMethod = stackTrace.length > 0 ? stackTrace[0] : null;
            return firstMethod != null && "org.apache.xerces.parsers.AbstractDOMParser".equals(firstMethod.getClassName()) && "characters".equals(firstMethod.getMethodName());
        }
        return false;
    }
}

