/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.transformation.service;

import eu.europeana.metis.transformation.service.CacheValueSupplier;
import eu.europeana.metis.transformation.service.CacheWithExpirationTime;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.TransformationException;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.lang3.StringUtils;

public class XsltTransformer
implements Closeable {
    private static final CacheWithExpirationTime<String, Templates> TEMPLATES_CACHE = new CacheWithExpirationTime();
    private final HttpClient httpClient = HttpClient.newBuilder().build();
    private final Transformer transformer;

    public XsltTransformer(String xsltUrl) throws TransformationException {
        this(xsltUrl, null, null, null);
    }

    public XsltTransformer(String xsltUrl, InputStream xsltInputStream) throws TransformationException {
        this(xsltUrl, xsltInputStream, null, null, null);
    }

    public XsltTransformer(String xsltKey, InputStream xsltInputStream, String datasetName, String edmCountry, String edmLanguage) throws TransformationException {
        try {
            this.transformer = this.getTemplatesFromUrlOrStream(xsltKey, xsltInputStream).newTransformer();
        }
        catch (CacheValueSupplier.CacheValueSupplierException | TransformerConfigurationException e) {
            throw new TransformationException(e);
        }
        this.setTransformerParameters(datasetName, edmCountry, edmLanguage);
    }

    public XsltTransformer(String xsltUrl, String datasetName, String edmCountry, String edmLanguage) throws TransformationException {
        try {
            this.transformer = this.getTemplates(xsltUrl).newTransformer();
        }
        catch (CacheValueSupplier.CacheValueSupplierException | TransformerConfigurationException e) {
            throw new TransformationException(e);
        }
        this.setTransformerParameters(datasetName, edmCountry, edmLanguage);
    }

    private Templates getTemplates(String xsltUrl) throws CacheValueSupplier.CacheValueSupplierException {
        return TEMPLATES_CACHE.getFromCache(xsltUrl, () -> this.createTemplatesFromUrl(xsltUrl));
    }

    private Templates getTemplatesFromUrlOrStream(String xsltKey, InputStream xsltInputStream) throws CacheValueSupplier.CacheValueSupplierException {
        Templates templates;
        try {
            templates = TEMPLATES_CACHE.getFromCache(xsltKey, () -> this.createTemplatesFromUrl(xsltKey));
        }
        catch (CacheValueSupplier.CacheValueSupplierException | IllegalArgumentException | NullPointerException e) {
            templates = TEMPLATES_CACHE.getFromCache(xsltKey, () -> XsltTransformer.createTemplatesFromInputStream(xsltInputStream));
        }
        return templates;
    }

    private static Templates createTemplatesFromInputStream(InputStream xsltInputStream) throws CacheValueSupplier.CacheValueSupplierException {
        try {
            TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
            return transformerFactory.newTemplates(new StreamSource(xsltInputStream));
        }
        catch (TransformerConfigurationException e) {
            throw new CacheValueSupplier.CacheValueSupplierException(e);
        }
    }

    private Templates createTemplatesFromUrl(String xsltUrl) throws CacheValueSupplier.CacheValueSupplierException {
        Templates templates;
        block9: {
            HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(xsltUrl)).build();
            InputStream xsltStream = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream()).body();
            try {
                TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
                templates = transformerFactory.newTemplates(new StreamSource(xsltStream));
                if (xsltStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (xsltStream != null) {
                        try {
                            xsltStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TransformerConfigurationException e) {
                    throw new CacheValueSupplier.CacheValueSupplierException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CacheValueSupplier.CacheValueSupplierException(e);
                }
            }
            xsltStream.close();
        }
        return templates;
    }

    public static void setExpirationTime(Duration expirationTime) {
        TEMPLATES_CACHE.setExpirationTime(expirationTime);
    }

    public static void setLenientWithReloads(boolean lenientWithReloads) {
        TEMPLATES_CACHE.setLenientWithReloads(lenientWithReloads);
    }

    public static void removeItemsNotAccessedSince(Duration since) {
        TEMPLATES_CACHE.removeItemsNotAccessedSince(since);
    }

    private void setTransformerParameters(String datasetName, String edmCountry, String edmLanguage) {
        if (StringUtils.isNotBlank((CharSequence)datasetName)) {
            this.transformer.setParameter("datasetName", datasetName);
        }
        if (StringUtils.isNotBlank((CharSequence)edmLanguage)) {
            this.transformer.setParameter("edmLanguage", edmLanguage);
        }
        if (StringUtils.isNotBlank((CharSequence)edmCountry)) {
            this.transformer.setParameter("edmCountry", edmCountry);
        }
    }

    public StringWriter transform(byte[] fileContent, EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap) throws TransformationException {
        StringWriter result = new StringWriter();
        this.transform(fileContent, result, europeanaGeneratedIdsMap);
        return result;
    }

    public byte[] transformToBytes(byte[] fileContent, EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap) throws TransformationException {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
                this.transform(fileContent, writer, europeanaGeneratedIdsMap);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TransformationException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    public void transform(byte[] fileContent, Writer writer, EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap) throws TransformationException {
        if (europeanaGeneratedIdsMap != null) {
            this.transformer.setParameter("providedCHOAboutId", europeanaGeneratedIdsMap.getEuropeanaGeneratedId());
            this.transformer.setParameter("aggregationAboutId", europeanaGeneratedIdsMap.getAggregationAboutPrefixed());
            this.transformer.setParameter("europeanaAggregationAboutId", europeanaGeneratedIdsMap.getEuropeanaAggregationAboutPrefixed());
            this.transformer.setParameter("proxyAboutId", europeanaGeneratedIdsMap.getProxyAboutPrefixed());
            this.transformer.setParameter("europeanaProxyAboutId", europeanaGeneratedIdsMap.getEuropeanaProxyAboutPrefixed());
            this.transformer.setParameter("dcIdentifier", europeanaGeneratedIdsMap.getSourceProvidedChoAbout());
        }
        try (ByteArrayInputStream contentStream = new ByteArrayInputStream(fileContent);){
            this.transformer.transform(new StreamSource(contentStream), new StreamResult(writer));
        }
        catch (IOException | TransformerException e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
    }
}

