/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.transformation.service;

import eu.europeana.metis.transformation.service.CacheItemWithExpirationTime;
import eu.europeana.metis.transformation.service.CacheValueSupplier;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheWithExpirationTime<K, V> {
    protected static final Duration DEFAULT_EXPIRATION_TIME = Duration.ZERO.plusHours(1L);
    protected static final boolean DEFAULT_LENIENCY_MODE = true;
    private final Map<K, CacheItemWithExpirationTime<V>> cache = new HashMap<K, CacheItemWithExpirationTime<V>>();
    private Duration expirationTime;
    private boolean lenientWithReloads;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public CacheWithExpirationTime(Duration expirationTime, boolean lenientWithReloads) {
        if (expirationTime == null) {
            throw new IllegalArgumentException();
        }
        this.expirationTime = expirationTime;
        this.lenientWithReloads = lenientWithReloads;
    }

    public CacheWithExpirationTime() {
        this(DEFAULT_EXPIRATION_TIME, true);
    }

    public void setExpirationTime(Duration expirationTime) {
        this.lock.writeLock().lock();
        try {
            this.expirationTime = expirationTime;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Duration getExpirationTime() {
        this.lock.readLock().lock();
        try {
            Duration duration = this.expirationTime;
            return duration;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setLenientWithReloads(boolean lenientWithReloads) {
        this.lock.writeLock().lock();
        try {
            this.lenientWithReloads = lenientWithReloads;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean isLenientWithReloads() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.lenientWithReloads;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheValueResolver<V> getValueResolver(K key) {
        this.lock.readLock().lock();
        try {
            if (this.cache.containsKey(key)) {
                CacheItemWithExpirationTime<V> cachedItem = this.cache.get(key);
                CacheValueResolver<Object> cacheValueResolver = supplier -> cachedItem.getValue(this.expirationTime, supplier, this.lenientWithReloads);
                return cacheValueResolver;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.cache.containsKey(key)) {
                CacheItemWithExpirationTime<V> cachedItem = this.cache.get(key);
                CacheValueResolver<Object> cacheValueResolver = supplier -> cachedItem.getValue(this.expirationTime, supplier, this.lenientWithReloads);
                return cacheValueResolver;
            }
            CacheItemWithExpirationTime result = new CacheItemWithExpirationTime();
            this.cache.put(key, result);
            CacheValueResolver<Object> cacheValueResolver = supplier -> result.getValue(this.expirationTime, supplier, this.lenientWithReloads);
            return cacheValueResolver;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public V getFromCache(K key, CacheValueSupplier<V> valueSupplier) throws CacheValueSupplier.CacheValueSupplierException {
        return this.getValueResolver(key).apply(valueSupplier);
    }

    public void removeItemsNotAccessedSince(Duration since) {
        this.lock.writeLock().lock();
        try {
            this.cache.entrySet().removeIf(entry -> !((CacheItemWithExpirationTime)entry.getValue()).valueWasAccessedRecently(since));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static interface CacheValueResolver<V> {
        public V apply(CacheValueSupplier<V> var1) throws CacheValueSupplier.CacheValueSupplierException;
    }
}

