/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.transformation.service;

import eu.europeana.metis.transformation.service.CacheValueSupplier;
import eu.europeana.metis.transformation.service.CacheWithExpirationTime;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.TransformationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.time.Duration;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsltTransformer.class);
    private static final CacheWithExpirationTime<String, Templates> TEMPLATES_CACHE = new CacheWithExpirationTime();
    private final Transformer transformer;

    public XsltTransformer(String xsltUrl) throws TransformationException {
        this(xsltUrl, null, null, null);
    }

    public XsltTransformer(String xsltUrl, String datasetName, String edmCountry, String edmLanguage) throws TransformationException {
        try {
            this.transformer = XsltTransformer.getTemplates(xsltUrl).newTransformer();
        }
        catch (CacheValueSupplier.CacheValueSupplierException | TransformerConfigurationException e) {
            LOGGER.error("Exception during transformation setup", (Throwable)e);
            throw new TransformationException(e);
        }
        if (datasetName != null && !datasetName.trim().isEmpty()) {
            this.transformer.setParameter("datasetName", datasetName);
        }
        if (edmLanguage != null && !edmLanguage.trim().isEmpty()) {
            this.transformer.setParameter("edmLanguage", edmLanguage);
        }
        if (edmCountry != null && !edmCountry.trim().isEmpty()) {
            this.transformer.setParameter("edmCountry", edmCountry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringWriter transform(byte[] fileContent, EuropeanaGeneratedIdsMap europeanaGeneratedIdsMap) throws TransformationException {
        if (europeanaGeneratedIdsMap != null) {
            this.transformer.setParameter("providedCHOAboutId", europeanaGeneratedIdsMap.getEuropeanaGeneratedId());
            this.transformer.setParameter("aggregationAboutId", europeanaGeneratedIdsMap.getAggregationAboutPrefixed());
            this.transformer.setParameter("europeanaAggregationAboutId", europeanaGeneratedIdsMap.getEuropeanaAggregationAboutPrefixed());
            this.transformer.setParameter("proxyAboutId", europeanaGeneratedIdsMap.getProxyAboutPrefixed());
            this.transformer.setParameter("europeanaProxyAboutId", europeanaGeneratedIdsMap.getEuropeanaProxyAboutPrefixed());
            this.transformer.setParameter("dcIdentifier", europeanaGeneratedIdsMap.getSourceProvidedChoAbout());
        }
        try (ByteArrayInputStream contentStream = new ByteArrayInputStream(fileContent);){
            StringWriter result = new StringWriter();
            this.transformer.transform(new StreamSource(contentStream), new StreamResult(result));
            StringWriter stringWriter = result;
            return stringWriter;
        }
        catch (IOException | TransformerException e) {
            LOGGER.error("Exception during transformation", (Throwable)e);
            throw new TransformationException(e);
        }
    }

    private static Templates getTemplates(String xsltUrl) throws CacheValueSupplier.CacheValueSupplierException {
        return TEMPLATES_CACHE.getFromCache(xsltUrl, () -> XsltTransformer.createTemplatesFromUrl(xsltUrl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Templates createTemplatesFromUrl(String xsltUrl) throws CacheValueSupplier.CacheValueSupplierException {
        TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
        try (InputStream xsltStream = new URL(xsltUrl).openStream();){
            Templates templates = transformerFactory.newTemplates(new StreamSource(xsltStream));
            return templates;
        }
        catch (IOException | TransformerConfigurationException e) {
            throw new CacheValueSupplier.CacheValueSupplierException(e);
        }
    }

    public static void setExpirationTime(Duration expirationTime) {
        TEMPLATES_CACHE.setExpirationTime(expirationTime);
    }

    public static void setLenientWithReloads(boolean lenientWithReloads) {
        TEMPLATES_CACHE.setLenientWithReloads(lenientWithReloads);
    }

    public static void removeItemsNotAccessedSince(Duration since) {
        TEMPLATES_CACHE.removeItemsNotAccessedSince(since);
    }
}

