/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.transformation.service;

import eu.europeana.corelib.definitions.jibx.AboutType;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.metis.transformation.service.EuropeanaGeneratedIdsMap;
import eu.europeana.metis.transformation.service.EuropeanaIdException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class EuropeanaIdCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EuropeanaIdCreator.class);
    private static final int EVALUATE_XPATH_ATTEMPT_COUNT = 20;
    private static final int EVALUATE_XPATH_ATTEMPT_INTERVAL_IN_MS = 50;
    private static final String RDF_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDF_NAMESPACE_PREFIX = "rdf";
    private static final String EDM_NAMESPACE_URI = "http://www.europeana.eu/schemas/edm/";
    private static final String EDM_NAMESPACE_PREFIX = "edm";
    private static final String RDF_ABOUT_EXPRESSION = String.format("/%s:RDF/%s:ProvidedCHO[1]/@%s:about", "rdf", "edm", "rdf");
    private static final Pattern LEGACY_COLLECTION_ID_PATTERN = Pattern.compile("[a-zA-Z]");
    private static final Pattern LEGACY_RDF_ABOUT_REPLACE_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
    private static final String REPLACEMENT_CHARACTER = "_";
    private static final Supplier<EuropeanaIdException> ID_NOT_FOUND_EXCEPTION_SUPPLIER = () -> new EuropeanaIdException("Could not find provider ID in source.");
    private final XPathExpression rdfAboutExtractor;

    public EuropeanaIdCreator() throws EuropeanaIdException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new RdfNamespaceResolver());
        try {
            this.rdfAboutExtractor = xpath.compile(RDF_ABOUT_EXPRESSION);
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Something went wrong while setting up the xpath.", (Throwable)e);
            throw new EuropeanaIdException("Something went wrong while setting up the xpath.", e);
        }
    }

    public EuropeanaGeneratedIdsMap constructEuropeanaId(RDF rdf, String datasetId) throws EuropeanaIdException {
        String rdfAbout = this.extractRdfAboutFromRdf(rdf);
        String europeanaIdFromRdfAbout = this.constructEuropeanaIdFromRdfAbout(rdfAbout, datasetId);
        return new EuropeanaGeneratedIdsMap(rdfAbout, europeanaIdFromRdfAbout);
    }

    public EuropeanaGeneratedIdsMap constructEuropeanaId(String rdfString, String datasetId) throws EuropeanaIdException {
        String rdfAbout = this.extractRdfAboutFromRdfString(rdfString);
        String europeanaIdFromRdfAbout = this.constructEuropeanaIdFromRdfAbout(rdfAbout, datasetId);
        return new EuropeanaGeneratedIdsMap(rdfAbout, europeanaIdFromRdfAbout);
    }

    private String constructEuropeanaIdFromRdfAbout(String rdfAbout, String datasetId) {
        return "/" + EuropeanaIdCreator.sanitizeDatasetIdLegacy(datasetId) + "/" + EuropeanaIdCreator.sanitizeRdfAboutLegacy(rdfAbout);
    }

    private static String sanitizeRdfAboutLegacy(String rdfAbout) {
        String recordId = rdfAbout.startsWith("http://") ? EuropeanaIdCreator.substringAfterLegacy(EuropeanaIdCreator.substringAfterLegacy(rdfAbout, "http://"), "/") : rdfAbout;
        Matcher matcher = LEGACY_RDF_ABOUT_REPLACE_PATTERN.matcher(recordId);
        return matcher.replaceAll(REPLACEMENT_CHARACTER);
    }

    private static String substringAfterLegacy(String str, String separator) {
        int pos = str.indexOf(separator);
        if (pos < 0) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    private static String sanitizeDatasetIdLegacy(String collectionId) {
        Matcher matcher = LEGACY_COLLECTION_ID_PATTERN.matcher(collectionId.substring(collectionId.length() - 1, collectionId.length()));
        return matcher.find() ? collectionId.substring(0, collectionId.length() - 1) : collectionId;
    }

    private String extractRdfAboutFromRdf(RDF rdf) throws EuropeanaIdException {
        String result = rdf.getProvidedCHOList().stream().filter(Objects::nonNull).findFirst().map(AboutType::getAbout).orElse(null);
        if (result == null || result.trim().isEmpty()) {
            throw ID_NOT_FOUND_EXCEPTION_SUPPLIER.get();
        }
        return result;
    }

    private String extractRdfAboutFromRdfString(String rdfString) throws EuropeanaIdException {
        String result;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(rdfString.getBytes(StandardCharsets.UTF_8));){
            result = this.extractRdfAboutFromInputStream(inputStream);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread interrupted.");
            Thread.currentThread().interrupt();
            return null;
        }
        catch (IOException e) {
            throw new EuropeanaIdException("Something went wrong while extracting the provider ID from the source.", e);
        }
        if (result == null || result.trim().isEmpty()) {
            throw ID_NOT_FOUND_EXCEPTION_SUPPLIER.get();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String extractRdfAboutFromInputStream(InputStream inputStream) throws EuropeanaIdException, InterruptedException {
        XPathExpressionException xpathException = null;
        int i = 0;
        while (i < 20) {
            if (i > 0) {
                Thread.sleep(50L);
            }
            Class<EuropeanaIdCreator> clazz = EuropeanaIdCreator.class;
            // MONITORENTER : eu.europeana.metis.transformation.service.EuropeanaIdCreator.class
            try {
                // MONITOREXIT : clazz
                return (String)this.rdfAboutExtractor.evaluate(new InputSource(inputStream), XPathConstants.STRING);
            }
            catch (XPathExpressionException e) {
                if (!EuropeanaIdCreator.isRaceCondition(e)) throw new EuropeanaIdException("Something went wrong while extracting the provider ID from the source.", e);
                LOGGER.warn("Race condition error occurred during attempt {} of {}. Trying again...", new Object[]{i, 20, e});
                xpathException = e;
                // MONITOREXIT : clazz
                ++i;
            }
        }
        throw new EuropeanaIdException("Last XPath evaluation attempt generated exception.", xpathException);
    }

    private static boolean isRaceCondition(Exception exception) {
        if (exception.getMessage() != null && exception.getMessage().contains("FWK005 parse may not be called while parsing")) {
            return true;
        }
        if (exception.getCause() instanceof NullPointerException) {
            StackTraceElement[] stackTrace = exception.getCause().getStackTrace();
            StackTraceElement firstMethod = stackTrace.length > 0 ? stackTrace[0] : null;
            return firstMethod != null && "org.apache.xerces.parsers.AbstractDOMParser".equals(firstMethod.getClassName()) && "characters".equals(firstMethod.getMethodName());
        }
        return false;
    }

    private static final class RdfNamespaceResolver
    implements NamespaceContext {
        private RdfNamespaceResolver() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String result;
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            switch (prefix) {
                case "rdf": {
                    result = EuropeanaIdCreator.RDF_NAMESPACE_URI;
                    break;
                }
                case "edm": {
                    result = EuropeanaIdCreator.EDM_NAMESPACE_URI;
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

