/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.transformation.service;

import eu.europeana.metis.transformation.service.CacheValueSupplier;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheItemWithExpirationTime<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheItemWithExpirationTime.class);
    private V value;
    private Instant creationTime;
    private Instant lastAccessTime;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    CacheItemWithExpirationTime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValue(Duration expirationTime, CacheValueSupplier<V> supplier, boolean lenientWithReloads) throws CacheValueSupplier.CacheValueSupplierException {
        this.lastAccessTime = this.getNow();
        this.lock.readLock().lock();
        try {
            if (this.isInstantInInterval(this.creationTime, expirationTime, this.getNow())) {
                V v = this.value;
                return v;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.isInstantInInterval(this.creationTime, expirationTime, this.getNow())) {
                V v = this.value;
                return v;
            }
            try {
                this.value = supplier.get();
            }
            catch (CacheValueSupplier.CacheValueSupplierException e) {
                if (this.creationTime == null || !lenientWithReloads) {
                    throw e;
                }
                LOGGER.warn("Could not obtain value for caching.", (Throwable)e);
            }
            this.creationTime = this.getNow();
            V v = this.value;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean isInstantInInterval(Instant start, Duration length, Instant instant) {
        return start != null && !start.isAfter(instant) && !start.plus(length).isBefore(instant);
    }

    boolean valueWasAccessedRecently(Duration since) {
        return this.isInstantInInterval(this.getLastAccessTime(), since, this.getNow());
    }

    Instant getCreationTime() {
        this.lock.readLock().lock();
        try {
            Instant instant = this.creationTime;
            return instant;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    Instant getNow() {
        return Instant.now();
    }
}

