/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.rest;

import com.lyncode.xml.exceptions.XmlWriteException;
import eu.europeana.metis.repository.dao.Record;
import eu.europeana.metis.repository.dao.RecordDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.ws.rs.QueryParam;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.xoai.model.oaipmh.GetRecord;
import org.dspace.xoai.model.oaipmh.Granularity;
import org.dspace.xoai.model.oaipmh.Header;
import org.dspace.xoai.model.oaipmh.ListIdentifiers;
import org.dspace.xoai.model.oaipmh.Metadata;
import org.dspace.xoai.model.oaipmh.OAIPMH;
import org.dspace.xoai.model.oaipmh.Request;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.services.api.ResumptionTokenFormat;
import org.dspace.xoai.services.impl.SimpleResumptionTokenFormat;
import org.dspace.xoai.xml.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tags(value={@Tag(name="OaiPmhController", description="Controller providing access to OAI-PMH harvesting functionality.")})
@Api(tags={"OaiPmhController"})
public class OaiPmhController {
    public static final String CONTROLLER_TAG_NAME = "OaiPmhController";
    private static final Logger LOGGER = LoggerFactory.getLogger(OaiPmhController.class);
    private RecordDao recordDao;

    @Autowired
    void setRecordDao(RecordDao recordDao) {
        this.recordDao = recordDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/repository/oai"}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="OAI endpoint (supporting only the ListIdentifiers and GetRecord verbs)")
    @ApiResponses(value={@ApiResponse(code=400, message="Illegal OAI request"), @ApiResponse(code=404, message="Unknown dataset or record ID"), @ApiResponse(code=500, message="Error processing the request")})
    public String oaiPmh(@ApiParam(value="The verb (ListIdentifiers or GetRecords)", required=true) @QueryParam(value="verb") String verb, @ApiParam(value="The set (required for ListIdentifiers)") @QueryParam(value="set") String set, @ApiParam(value="The metadataPrefix (only 'edm' is supported.)", required=true) @QueryParam(value="metadataPrefix") String metadataPrefix, @ApiParam(value="The record identifier (required for GetRecord)") @QueryParam(value="identifier") String identifier) {
        ListIdentifiers verbResult;
        if (!"edm".equals(metadataPrefix)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Unsupported metadataPrefix value: " + metadataPrefix);
        }
        if ("ListIdentifiers".equals(verb)) {
            verbResult = this.listIdentifiers(set);
        } else if ("GetRecord".equals(verb)) {
            verbResult = this.getRecord(identifier);
        } else {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Unsupported verb: " + verb);
        }
        OAIPMH result = new OAIPMH().withVerb((Verb)verbResult).withResponseDate(new Date()).withRequest(new Request("/repository/oai").withVerbType(verbResult.getType()));
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XmlWriter.WriterContext context = new XmlWriter.WriterContext(Granularity.Day, (ResumptionTokenFormat)new SimpleResumptionTokenFormat());
            try (XmlWriter writer = new XmlWriter((OutputStream)outputStream, context);){
                result.write(writer);
            }
            return outputStream.toString();
        }
        catch (XmlWriteException | XMLStreamException e) {
            LOGGER.warn("A problem occurred while serializing the response.", e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "A problem occurred while serializing the response.", e);
        }
    }

    private ListIdentifiers listIdentifiers(String setSpec) {
        if (StringUtils.isBlank((CharSequence)setSpec)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Please provide a set value");
        }
        ListIdentifiers result = new ListIdentifiers();
        this.recordDao.getAllRecordsFromDataset(setSpec).forEach(record -> result.getHeaders().add(OaiPmhController.createHeader((Record)record)));
        if (result.getHeaders().isEmpty()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No records found for this dataset.");
        }
        return result;
    }

    private GetRecord getRecord(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Please provide an identifier");
        }
        Record record = this.recordDao.getRecord(identifier);
        if (record == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No record found for this identifier.");
        }
        org.dspace.xoai.model.oaipmh.Record resultRecord = new org.dspace.xoai.model.oaipmh.Record().withHeader(OaiPmhController.createHeader((Record)record)).withMetadata(new Metadata(record.getEdmRecord()));
        return new GetRecord(resultRecord);
    }

    private static Header createHeader(Record record) {
        Header result = new Header().withDatestamp(Date.from(record.getDateStamp())).withSetSpec(record.getDatasetId()).withIdentifier(record.getRecordId());
        if (record.isDeleted()) {
            result.withStatus(Header.Status.DELETED);
        }
        return result;
    }
}

