/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.rest;

import eu.europeana.metis.repository.dao.Record;
import eu.europeana.metis.repository.dao.RecordDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tags(value={@Tag(name="HttpHarvestController", description="Controller providing access to HTTP (zip) harvesting functionality.")})
@Api(tags={"HttpHarvestController"})
public class HttpHarvestController {
    public static final String CONTROLLER_TAG_NAME = "HttpHarvestController";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpHarvestController.class);
    private RecordDao recordDao;

    @Autowired
    void setRecordDao(RecordDao recordDao) {
        this.recordDao = recordDao;
    }

    @GetMapping(value={"/repository/zip/{dataset}.zip"}, produces={"application/zip"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="The dataset is exported as a zip file for harvesting by Metis. Records that are marked as deleted will be excluded from the resulting zip file.")
    @ApiResponses(value={@ApiResponse(code=404, message="No records for this dataset."), @ApiResponse(code=500, message="Error obtaining the records.")})
    public ResponseEntity<byte[]> getDatasetRecords(@ApiParam(value="Dataset ID (new or existing)", required=true) @PathVariable(value="dataset") String datasetId) {
        AtomicBoolean recordsFound = new AtomicBoolean(false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            Stream recordList = this.recordDao.getAllRecordsFromDataset(datasetId);
            recordList.forEach(record -> {
                if (!record.isDeleted()) {
                    HttpHarvestController.addRecordToZipFile((Record)record, (ZipOutputStream)zipOutputStream);
                    recordsFound.set(true);
                }
            });
            zipOutputStream.finish();
            zipOutputStream.flush();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("There was problems while zipping the records.", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        if (!recordsFound.get()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No records found for this dataset.");
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + datasetId + ".zip\""})).body((Object)byteArrayOutputStream.toByteArray());
    }

    private static void addRecordToZipFile(Record record, ZipOutputStream zipOutputStream) {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(record.getRecordId() + ".xml"));
            zipOutputStream.write(record.getEdmRecord().getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            throw new IllegalStateException("There was a problem while preparing the records to be zipped.", e);
        }
    }
}

