/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.dao;

import com.mongodb.client.MongoClient;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.mapping.DiscriminatorFunction;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.NamingStrategy;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import eu.europeana.metis.network.ExternalRequestUtil;
import eu.europeana.metis.repository.dao.Record;
import eu.europeana.metis.utils.CommonStringValues;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordDao.class);
    private static final String RECORD_ID_FIELD = "recordId";
    private static final String DATASET_ID_FIELD = "datasetId";
    private final Datastore datastore;

    public RecordDao(MongoClient mongo, String databaseName) {
        MapperOptions mapperOptions = MapperOptions.builder().discriminatorKey("className").discriminator(DiscriminatorFunction.className()).collectionNaming(NamingStrategy.identity()).build();
        this.datastore = Morphia.createDatastore((MongoClient)mongo, (String)databaseName, (MapperOptions)mapperOptions);
        this.datastore.getMapper().map(new Class[]{Record.class});
    }

    public boolean createRecord(Record providedRecord) {
        Optional<Record> recordFound = this.datastore.find(Record.class).filter(new Filter[]{Filters.eq((String)RECORD_ID_FIELD, (Object)providedRecord.getRecordId())}).stream().findFirst();
        recordFound.ifPresent(value -> providedRecord.setId(value.getId()));
        ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> (Record)this.datastore.save((Object)providedRecord));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Record for datasetId '{}' created in Mongo", (Object)CommonStringValues.CRLF_PATTERN.matcher(providedRecord.getDatasetId()).replaceAll(""));
        }
        return recordFound.isEmpty();
    }

    public Stream<Record> getAllRecordsFromDataset(String datasetId) {
        return this.datastore.find(Record.class).filter(new Filter[]{Filters.eq((String)DATASET_ID_FIELD, (Object)datasetId)}).stream();
    }

    public Record getRecord(String recordId) {
        Optional recordFound = this.datastore.find(Record.class).filter(new Filter[]{Filters.eq((String)RECORD_ID_FIELD, (Object)recordId)}).stream().findFirst();
        if (recordFound.isPresent()) {
            return (Record)recordFound.get();
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("There is no such record with id {}.", (Object)CommonStringValues.CRLF_PATTERN.matcher(recordId).replaceAll(""));
        }
        return null;
    }

    public boolean deleteRecord(String recordId) {
        boolean isDeleted;
        boolean bl = isDeleted = this.datastore.find(Record.class).filter(new Filter[]{Filters.eq((String)RECORD_ID_FIELD, (Object)recordId)}).delete().getDeletedCount() > 0L;
        if (!isDeleted) {
            LOGGER.warn("There is no such record with id {}.", (Object)recordId);
        }
        return isDeleted;
    }
}

