/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.config;

import com.mongodb.client.MongoClient;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.metis.mongo.connection.MongoClientProvider;
import eu.europeana.metis.mongo.connection.MongoProperties;
import eu.europeana.metis.repository.config.ApplicationPropertiesHolder;
import eu.europeana.metis.repository.dao.RecordDao;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import java.util.Collections;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableWebMvc
@EnableSwagger2
@ComponentScan(basePackages={"eu.europeana.metis.repository.config", "eu.europeana.metis.repository.rest"})
public class MetisRepositoryRestApplication
implements WebMvcConfigurer,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetisRepositoryRestApplication.class);
    private final ApplicationPropertiesHolder properties;
    private MongoClient mongoClientForEntities;

    @Autowired
    public MetisRepositoryRestApplication(ApplicationPropertiesHolder properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (this.properties.isSocksProxyEnabled()) {
            new SocksProxy(this.properties.getSocksProxyHost(), this.properties.getSocksProxyPort(), this.properties.getSocksProxyUsername(), this.properties.getSocksProxyPassword()).init();
        }
        LOGGER.info("Append default truststore with custom truststore");
        if (StringUtils.isNotEmpty((CharSequence)this.properties.getTruststorePath()) && StringUtils.isNotEmpty((CharSequence)this.properties.getTruststorePassword())) {
            CustomTruststoreAppender.appendCustomTrustoreToDefault((String)this.properties.getTruststorePath(), (String)this.properties.getTruststorePassword());
        }
        LOGGER.info("Creating Mongo connection");
        MongoProperties mongoProperties = new MongoProperties(IllegalArgumentException::new);
        mongoProperties.setAllProperties(this.properties.getMongoHosts(), new int[]{this.properties.getMongoPort()}, this.properties.getMongoAuthenticationDb(), this.properties.getMongoUsername(), this.properties.getMongoPassword(), this.properties.isMongoEnableSsl(), MongoProperties.ReadPreferenceValue.PRIMARY_PREFERRED, this.properties.getMongoApplicationName());
        this.mongoClientForEntities = new MongoClientProvider(mongoProperties).createMongoClient();
    }

    @Bean(name={"multipartResolver"})
    public StandardServletMultipartResolver getMultipartResolver() {
        return new StandardServletMultipartResolver();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/springfox-swagger-ui/"}).resourceChain(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "/swagger-ui/index.html");
    }

    @Bean
    public Docket api() {
        return new Docket(DocumentationType.SWAGGER_2).useDefaultResponseMessages(false).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.any()).build().apiInfo(this.apiInfo());
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Metis Repository REST API", "Metis Repository REST API", "v1", "API TOS", new Contact("development", "europeana.eu", "development@europeana.eu"), "EUPL Licence v1.2", "https://joinup.ec.europa.eu/collection/eupl/eupl-text-eupl-12", Collections.emptyList());
    }

    @Bean
    public RecordDao getRecordDao() {
        return new RecordDao(this.mongoClientForEntities, this.properties.getMongoRecordDb());
    }

    @PreDestroy
    public void close() {
        if (this.mongoClientForEntities != null) {
            this.mongoClientForEntities.close();
        }
    }
}

