/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.rest.view;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import eu.europeana.metis.repository.rest.view.InstantSerializer;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InsertionResult {
    private final String datasetId;
    @JsonSerialize(using=InstantSerializer.class)
    private final Instant dateStamp;
    private int insertedRecords = 0;
    private int updatedRecords = 0;
    private final Set<String> insertedRecordIds = new HashSet();
    private final Set<String> updatedRecordIds = new HashSet();

    public InsertionResult(String datasetId, Instant dateStamp) {
        this.datasetId = datasetId;
        this.dateStamp = dateStamp;
    }

    public void addInsertedRecord(String recordId) {
        if (this.insertedRecordIds.add(recordId)) {
            ++this.insertedRecords;
        }
    }

    public void addUpdatedRecord(String recordId) {
        if (this.updatedRecordIds.add(recordId)) {
            ++this.updatedRecords;
        }
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public Instant getDateStamp() {
        return this.dateStamp;
    }

    public int getInsertedRecords() {
        return this.insertedRecords;
    }

    public int getUpdatedRecords() {
        return this.updatedRecords;
    }

    public Set<String> getInsertedRecordIds() {
        return Collections.unmodifiableSet(this.insertedRecordIds);
    }

    public Set<String> getUpdatedRecordIds() {
        return Collections.unmodifiableSet(this.updatedRecordIds);
    }
}

