/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.rest.controller;

import eu.europeana.metis.repository.rest.controller.OaiPmhController;
import eu.europeana.metis.repository.rest.dao.RecordDao;
import io.gdcc.xoai.model.oaipmh.OAIPMH;
import io.gdcc.xoai.model.oaipmh.Request;
import io.gdcc.xoai.model.oaipmh.results.Record;
import io.gdcc.xoai.model.oaipmh.results.record.Header;
import io.gdcc.xoai.model.oaipmh.results.record.Metadata;
import io.gdcc.xoai.model.oaipmh.verbs.GetRecord;
import io.gdcc.xoai.model.oaipmh.verbs.ListIdentifiers;
import io.gdcc.xoai.model.oaipmh.verbs.Verb;
import io.gdcc.xoai.xml.WriterContext;
import io.gdcc.xoai.xml.XmlWriter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tags(value={@Tag(name="OaiPmhController", description="Controller providing access to OAI-PMH harvesting functionality.")})
@Api(tags={"OaiPmhController"})
public class OaiPmhController {
    public static final String CONTROLLER_TAG_NAME = "OaiPmhController";
    private RecordDao recordDao;

    private static Header createHeader(eu.europeana.metis.repository.rest.dao.Record oaiRecord) {
        Header result = new Header().withDatestamp(Date.from(oaiRecord.getDateStamp()).toInstant()).withSetSpec(oaiRecord.getDatasetId()).withIdentifier(oaiRecord.getRecordId());
        if (oaiRecord.isDeleted()) {
            result.withStatus(Header.Status.DELETED);
        }
        return result;
    }

    @Autowired
    public void setRecordDao(RecordDao recordDao) {
        this.recordDao = recordDao;
    }

    @GetMapping(value={"/repository/oai"}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="OAI endpoint (supporting only the ListIdentifiers and GetRecord verbs)")
    @ApiResponses(value={@ApiResponse(code=400, message="Illegal OAI request"), @ApiResponse(code=404, message="Unknown dataset or record ID"), @ApiResponse(code=500, message="Error processing the request")})
    public String oaiPmh(@ApiParam(value="The verb (ListIdentifiers or GetRecords)", required=true) @RequestParam(value="verb") String verb, @ApiParam(value="The set (required for ListIdentifiers)") @RequestParam(value="set", required=false) String set, @ApiParam(value="The metadataPrefix (only 'edm' is supported.)", required=true) @RequestParam(value="metadataPrefix") String metadataPrefix, @ApiParam(value="The record identifier (required for GetRecord)") @RequestParam(value="identifier", required=false) String identifier) {
        ListIdentifiers verbResult;
        if (!"edm".equals(metadataPrefix)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Unsupported metadataPrefix value: " + metadataPrefix);
        }
        if ("ListIdentifiers".equals(verb)) {
            verbResult = this.listIdentifiers(set);
        } else if ("GetRecord".equals(verb)) {
            verbResult = this.getRecord(identifier);
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Unsupported verb: " + verb);
        }
        OAIPMH result = new OAIPMH().withVerb((Verb)verbResult).withResponseDate(new Date().toInstant()).withRequest(new Request("/repository/oai").withVerb(verbResult.getType()));
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XmlOAIWriterContext context = new XmlOAIWriterContext();
            try (XmlWriter writer = new XmlWriter((OutputStream)outputStream, (WriterContext)context);){
                result.write(writer);
            }
            return outputStream.toString();
        }
        catch (XMLStreamException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "A problem occurred while serializing the response.", (Throwable)e);
        }
    }

    private ListIdentifiers listIdentifiers(String setSpec) {
        if (StringUtils.isBlank((CharSequence)setSpec)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Please provide a set value");
        }
        ListIdentifiers result = new ListIdentifiers();
        this.recordDao.getAllRecordsFromDataset(setSpec).forEach(datasetRecord -> result.getHeaders().add(OaiPmhController.createHeader((eu.europeana.metis.repository.rest.dao.Record)datasetRecord)));
        if (result.getHeaders().isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No records found for this dataset.");
        }
        return result;
    }

    private GetRecord getRecord(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Please provide an identifier");
        }
        eu.europeana.metis.repository.rest.dao.Record oaiRecord = this.recordDao.getRecord(identifier);
        if (oaiRecord == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "No record found for this identifier.");
        }
        Record resultRecord = new Record().withHeader(OaiPmhController.createHeader((eu.europeana.metis.repository.rest.dao.Record)oaiRecord)).withMetadata(new Metadata(oaiRecord.getEdmRecord()));
        return new GetRecord(resultRecord);
    }
}

