/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.repository.rest.config;

import com.mongodb.client.MongoClient;
import eu.europeana.metis.mongo.connection.MongoClientProvider;
import eu.europeana.metis.mongo.connection.MongoProperties;
import eu.europeana.metis.repository.rest.dao.RecordDao;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import eu.europeana.metis.utils.apm.ElasticAPMConfiguration;
import jakarta.annotation.PreDestroy;
import metis.common.config.properties.TruststoreConfigurationProperties;
import metis.common.config.properties.mongo.MongoConfigurationProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableWebMvc
@EnableConfigurationProperties(value={ElasticAPMConfiguration.class, TruststoreConfigurationProperties.class, MongoConfigurationProperties.class})
@ComponentScan(basePackages={"eu.europeana.metis.repository.rest.controller", "eu.europeana.metis.repository.rest.view"})
public class ApplicationConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationConfiguration.class);
    private final MongoClient mongoClient;

    @Autowired
    public ApplicationConfiguration(TruststoreConfigurationProperties truststoreConfigurationProperties, MongoConfigurationProperties mongoConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        ApplicationConfiguration.initializeTruststore((TruststoreConfigurationProperties)truststoreConfigurationProperties);
        this.mongoClient = ApplicationConfiguration.getMongoClient((MongoConfigurationProperties)mongoConfigurationProperties);
    }

    static void initializeTruststore(TruststoreConfigurationProperties truststoreConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPath()) && StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPassword())) {
            CustomTruststoreAppender.appendCustomTruststoreToDefault((String)truststoreConfigurationProperties.getPath(), (String)truststoreConfigurationProperties.getPassword());
            LOGGER.info("Custom truststore appended to default truststore");
        }
    }

    public static MongoClient getMongoClient(MongoConfigurationProperties mongoConfigurationProperties) {
        MongoProperties mongoProperties = new MongoProperties(IllegalArgumentException::new);
        mongoProperties.setAllProperties(mongoConfigurationProperties.getHosts(), mongoConfigurationProperties.getPorts(), mongoConfigurationProperties.getAuthenticationDatabase(), mongoConfigurationProperties.getUsername(), mongoConfigurationProperties.getPassword(), mongoConfigurationProperties.isEnableSsl(), MongoProperties.ReadPreferenceValue.PRIMARY_PREFERRED, mongoConfigurationProperties.getApplicationName());
        return new MongoClientProvider(mongoProperties).createMongoClient();
    }

    @Bean(name={"multipartResolver"})
    public StandardServletMultipartResolver getMultipartResolver() {
        return new StandardServletMultipartResolver();
    }

    @Bean
    public RecordDao getRecordDao(MongoConfigurationProperties mongoConfigurationProperties) {
        return new RecordDao(this.mongoClient, mongoConfigurationProperties.getDatabase());
    }

    @PreDestroy
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }
}

