/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.patternanalysis.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Arrays;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum ProblemPatternDescription {
    P1(ProblemPatternId.P1, "Systematic use of the same title (ignoring case)", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.CONCISENESS),
    P2(ProblemPatternId.P2, "Equal title and description fields", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.CONCISENESS),
    P3(ProblemPatternId.P3, "Near-Identical title and description fields", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.CONCISENESS),
    P5(ProblemPatternId.P5, "Unrecognizable title", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.ACCURACY),
    P6(ProblemPatternId.P6, "Non-meaningful title", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.ACCURACY),
    P7(ProblemPatternId.P7, "Missing description fields", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.COMPLETENESS),
    P9(ProblemPatternId.P9, "Very short description", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.ACCURACY),
    P12(ProblemPatternId.P12, "Extremely long values", ProblemPatternSeverity.WARNING, ProblemPatternQualityDimension.ACCURACY);

    private final ProblemPatternId problemPatternId;
    private final String problemPatternTitle;
    private final ProblemPatternSeverity problemPatternSeverity;
    private final ProblemPatternQualityDimension problemPatternQualityDimension;

    private ProblemPatternDescription(ProblemPatternId problemPatternId, String problemPatternTitle, ProblemPatternSeverity problemPatternSeverity, ProblemPatternQualityDimension problemPatternQualityDimension) {
        this.problemPatternId = problemPatternId;
        this.problemPatternTitle = problemPatternTitle;
        this.problemPatternSeverity = problemPatternSeverity;
        this.problemPatternQualityDimension = problemPatternQualityDimension;
    }

    public ProblemPatternId getProblemPatternId() {
        return this.problemPatternId;
    }

    public String getProblemPatternTitle() {
        return this.problemPatternTitle;
    }

    public ProblemPatternSeverity getProblemPatternSeverity() {
        return this.problemPatternSeverity;
    }

    public ProblemPatternQualityDimension getProblemPatternQualityDimension() {
        return this.problemPatternQualityDimension;
    }

    public static ProblemPatternDescription fromName(String name) {
        return Arrays.stream(ProblemPatternDescription.values()).filter(value -> value.name().equalsIgnoreCase(name)).findFirst().orElseThrow();
    }

    public static enum ProblemPatternId {
        P1,
        P2,
        P3,
        P5,
        P6,
        P7,
        P9,
        P12;

    }

    public static enum ProblemPatternSeverity {
        NOTICE,
        WARNING,
        ERROR,
        FATAL;

    }

    public static enum ProblemPatternQualityDimension {
        ACCURACY,
        AVAILABILITY,
        COMPLETENESS,
        CONCISENESS,
        COMPLIANCE,
        CONSISTENCY,
        TIMELINESS,
        LICENSING,
        INTERLINKING,
        UNDERSTANDABILITY,
        REPRESENTATIONAL;

    }
}

