/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.patternanalysis.view;

import eu.europeana.patternanalysis.view.ProblemPattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ProblemPatternAnalysis {
    private final String rdfAbout;
    private final List<ProblemPattern> problemPatterns;
    private final Set<String> titles;

    public ProblemPatternAnalysis(String rdfAbout, List<ProblemPattern> problemPatterns, Set<String> titles) {
        this.rdfAbout = Objects.requireNonNull(rdfAbout);
        this.problemPatterns = Objects.requireNonNullElseGet(problemPatterns, ArrayList::new);
        this.titles = Objects.requireNonNullElseGet(titles, HashSet::new);
    }

    public String getRdfAbout() {
        return this.rdfAbout;
    }

    public List<ProblemPattern> getProblemPatterns() {
        return new ArrayList<ProblemPattern>(this.problemPatterns);
    }

    public Set<String> getTitles() {
        return new HashSet<String>(this.titles);
    }
}

