/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.patternanalysis.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import eu.europeana.patternanalysis.view.ProblemPattern;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class DatasetProblemPatternAnalysis<T> {
    private final String datasetId;
    private final T executionStep;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private final LocalDateTime executionTimestamp;
    private final List<ProblemPattern> problemPatternList;

    public DatasetProblemPatternAnalysis(String datasetId, T executionStep, LocalDateTime executionTimestamp, List<ProblemPattern> problemPatternList) {
        this.datasetId = datasetId;
        this.executionStep = executionStep;
        this.executionTimestamp = executionTimestamp;
        this.problemPatternList = problemPatternList == null ? new ArrayList<ProblemPattern>() : new ArrayList<ProblemPattern>(problemPatternList);
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public T getExecutionStep() {
        return this.executionStep;
    }

    public LocalDateTime getExecutionTimestamp() {
        return this.executionTimestamp;
    }

    public List<ProblemPattern> getProblemPatternList() {
        return new ArrayList<ProblemPattern>(this.problemPatternList);
    }
}

