/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

import eu.europeana.normalization.util.Namespace;
import eu.europeana.normalization.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class XpathQuery {
    public static final Namespace.Element RDF_TAG = Namespace.RDF.getElement("RDF");
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private final Map<String, String> namespaceByPrefixMap;
    private final String expressionFormat;
    private final String expression;
    private final List<Namespace.Element> elements;

    public XpathQuery(String expressionFormat, Namespace.Element ... elements) {
        this.expressionFormat = expressionFormat;
        this.elements = Arrays.asList(elements);
        int[] counter = new int[]{0};
        this.namespaceByPrefixMap = Arrays.stream(elements).map(Namespace.Element::getNamespace).map(Namespace::getUri).distinct().collect(Collectors.toMap(namespace -> {
            counter[0] = counter[0] + 1;
            return "ns" + counter[0];
        }, Function.identity()));
        Map<String, String> prefixByNamespaceMap = this.namespaceByPrefixMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Object[] parameters = this.elements.stream().map(element -> XpathQuery.elementToString(element, (String)prefixByNamespaceMap.get(element.getNamespace().getUri()))).toArray(Object[]::new);
        this.expression = String.format(expressionFormat, parameters).trim();
    }

    private static String elementToString(Namespace.Element element, String prefix) {
        return XmlUtil.addPrefixToNodeName(element.getElementName(), prefix);
    }

    public static XpathQuery combine(XpathQuery ... queries) {
        String expressionFormat = Arrays.stream(queries).map(query -> query.expressionFormat).collect(Collectors.joining(" | "));
        Namespace.Element[] elements = (Namespace.Element[])Arrays.stream(queries).map(query -> query.elements).flatMap(Collection::stream).toArray(Namespace.Element[]::new);
        return new XpathQuery(expressionFormat, elements);
    }

    private XPathExpression toXPath() throws XPathExpressionException {
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(new SimpleNamespaceContext(this.namespaceByPrefixMap::get));
        return xpath.compile(this.expression);
    }

    public NodeList execute(Document dom) throws XPathExpressionException {
        return (NodeList)this.toXPath().evaluate(dom, XPathConstants.NODESET);
    }

    private static class SimpleNamespaceContext
    implements NamespaceContext {
        private final UnaryOperator<String> namespaceByPrefixLookup;

        public SimpleNamespaceContext(UnaryOperator<String> namespaceByPrefixLookup) {
            this.namespaceByPrefixLookup = namespaceByPrefixLookup;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String result;
            if (prefix == null) {
                throw new IllegalArgumentException();
            }
            String resultFromMap = (String)this.namespaceByPrefixLookup.apply(prefix);
            if (resultFromMap != null) {
                return resultFromMap;
            }
            switch (prefix) {
                case "xml": {
                    result = "http://www.w3.org/XML/1998/namespace";
                    break;
                }
                case "xmlns": {
                    result = "http://www.w3.org/2000/xmlns/";
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

