/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.util;

public enum Namespace {
    XML("http://www.w3.org/XML/1998/namespace"),
    RDF("http://www.w3.org/1999/02/22-rdf-syntax-ns#"),
    EDM("http://www.europeana.eu/schemas/edm/"),
    ORE("http://www.openarchives.org/ore/terms/"),
    SKOS("http://www.w3.org/2004/02/skos/core#"),
    DC("http://purl.org/dc/elements/1.1/"),
    DCTERMS("http://purl.org/dc/terms/");

    private final String uri;

    private Namespace(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public Element getElement(String elementName) {
        return new Element(elementName, this);
    }

    public static final class Element {
        private final String elementName;
        private final Namespace namespace;

        private Element(String elementName, Namespace namespace) {
            this.elementName = elementName;
            this.namespace = namespace;
        }

        public Namespace getNamespace() {
            return this.namespace;
        }

        public String getElementName() {
            return this.elementName;
        }
    }
}

