/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.normalizers;

import eu.europeana.normalization.model.ConfidenceLevel;
import eu.europeana.normalization.model.NormalizationReport;
import eu.europeana.normalization.normalizers.InternalNormalizationReport;
import eu.europeana.normalization.normalizers.NormalizedValueWithConfidence;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.normalizers.ValueNormalizeAction;
import eu.europeana.normalization.util.Namespace;
import eu.europeana.normalization.util.NormalizationException;
import eu.europeana.normalization.util.XmlUtil;
import eu.europeana.normalization.util.XpathQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ValueNormalizeActionWrapper
implements RecordNormalizeAction {
    private final List<XpathQuery> targetElements = new ArrayList<XpathQuery>();
    private final ValueNormalizeAction normalization;
    private final CopySettings copySettings;

    ValueNormalizeActionWrapper(ValueNormalizeAction normalization, CopySettings copySettings, XpathQuery ... targetElements) {
        this.normalization = normalization;
        this.copySettings = copySettings;
        Collections.addAll(this.targetElements, targetElements);
    }

    ValueNormalizeActionWrapper(ValueNormalizeAction normalization, XpathQuery ... targetElements) {
        this(normalization, (CopySettings)null, targetElements);
    }

    private void normalizeAttribute(Element copyTarget, Set<String> valuesAlreadyPresent, Attr attribute, InternalNormalizationReport report) {
        String originalValue = attribute.getValue();
        List<NormalizedValueWithConfidence> normalizedValue = this.normalization.normalizeValue(originalValue);
        if (normalizedValue.size() != 1) {
            if (copyTarget == null) {
                attribute.getOwnerElement().getAttributes().removeNamedItemNS(attribute.getNamespaceURI(), attribute.getLocalName());
                report.increment(this.normalization.getClass().getSimpleName(), ConfidenceLevel.CERTAIN);
            }
        } else if (copyTarget == null) {
            boolean valueChanged;
            boolean bl = valueChanged = !normalizedValue.get(0).getNormalizedValue().equals(originalValue);
            if (valueChanged) {
                this.updateAttribute(attribute, normalizedValue.get(0), report);
            }
        } else {
            this.copyValue(copyTarget, valuesAlreadyPresent, normalizedValue.get(0), report);
        }
    }

    private void normalizeElement(Element copyTarget, Set<String> valuesAlreadyPresent, Element element, InternalNormalizationReport report) {
        String originalValue = XmlUtil.getElementText(element);
        List<NormalizedValueWithConfidence> normalizedValues = this.normalization.normalizeValue(originalValue);
        if (normalizedValues.isEmpty()) {
            if (copyTarget == null) {
                ValueNormalizeActionWrapper.removeTextFromElement(element);
                ValueNormalizeActionWrapper.removeElementIfEmpty(element);
                report.increment(this.normalization.getClass().getSimpleName(), ConfidenceLevel.CERTAIN);
            }
        } else if (copyTarget == null) {
            boolean valueChanged;
            boolean bl = valueChanged = normalizedValues.size() > 1 || !normalizedValues.get(0).getNormalizedValue().equals(originalValue);
            if (valueChanged) {
                this.updateElements(element, normalizedValues, report);
            }
        } else {
            normalizedValues.forEach(normalizedValue -> this.copyValue(copyTarget, valuesAlreadyPresent, (NormalizedValueWithConfidence)normalizedValue, report));
        }
    }

    private void copyValue(Element copyTarget, Set<String> valuesAlreadyPresent, NormalizedValueWithConfidence value, InternalNormalizationReport report) {
        boolean valueAdded = valuesAlreadyPresent.add(value.getNormalizedValue());
        if (valueAdded) {
            String prefix = copyTarget.lookupPrefix(this.copySettings.getDestinationElement().getNamespace().getUri());
            String newElementName = XmlUtil.addPrefixToNodeName(this.copySettings.getDestinationElement().getElementName(), prefix);
            Element newElement = copyTarget.getOwnerDocument().createElementNS(this.copySettings.getDestinationElement().getNamespace().getUri(), newElementName);
            this.addTextToElement(newElement, value, report);
            Node afterElemement = null;
            if (this.copySettings.getAfterElement() != null) {
                String afterElementName = XmlUtil.addPrefixToNodeName(this.copySettings.getAfterElement().getElementName(), copyTarget.lookupPrefix(this.copySettings.getAfterElement().getNamespace().getUri()));
                afterElemement = XmlUtil.getLastElementByTagName(copyTarget, afterElementName);
            }
            if (afterElemement == null) {
                copyTarget.appendChild(newElement);
            } else {
                Text textNode = copyTarget.getOwnerDocument().createTextNode(afterElemement.getNextSibling().getTextContent());
                copyTarget.replaceChild(newElement, afterElemement);
                copyTarget.insertBefore(textNode, newElement);
                copyTarget.insertBefore(afterElemement, textNode);
            }
        }
    }

    private static void removeElementIfEmpty(Element element) {
        if (element.hasChildNodes()) {
            return;
        }
        if (!element.hasAttributes() || element.getAttributes().getLength() == 1 && !StringUtils.isEmpty((CharSequence)element.getAttributeNS(Namespace.XML.getUri(), "lang"))) {
            element.getParentNode().removeChild(element);
        }
    }

    private void updateElements(Element element, List<NormalizedValueWithConfidence> normalizedValues, InternalNormalizationReport report) {
        ValueNormalizeActionWrapper.removeTextFromElement(element);
        this.addTextToElement(element, normalizedValues.get(0), report);
        normalizedValues.stream().skip(1L).forEach(normalizedValue -> {
            Element newElement = (Element)element.cloneNode(false);
            this.addTextToElement(newElement, (NormalizedValueWithConfidence)normalizedValue, report);
            element.getParentNode().insertBefore(newElement, element.getNextSibling());
        });
    }

    private static void removeTextFromElement(Element element) {
        NodeList childNodes = element.getChildNodes();
        IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).filter(childNode -> childNode.getNodeType() == 3).forEach(element::removeChild);
    }

    private void addTextToElement(Element element, NormalizedValueWithConfidence normalizedValue, InternalNormalizationReport report) {
        element.appendChild(element.getOwnerDocument().createTextNode(normalizedValue.getNormalizedValue()));
        report.increment(this.normalization.getClass().getSimpleName(), normalizedValue.getConfidenceClass());
    }

    private void updateAttribute(Attr attribute, NormalizedValueWithConfidence normalizedValue, InternalNormalizationReport report) {
        attribute.setValue(normalizedValue.getNormalizedValue());
        report.increment(this.normalization.getClass().getSimpleName(), normalizedValue.getConfidenceClass());
    }

    @Override
    public NormalizationReport normalize(Document edm) throws NormalizationException {
        InternalNormalizationReport report = new InternalNormalizationReport();
        Element copyTarget = this.copySettings == null ? null : ValueNormalizeActionWrapper.getCopyTargetFromSettings(edm, this.copySettings);
        HashSet<String> valuesAlreadyPresent = new HashSet<String>();
        if (copyTarget != null) {
            NodeList childNodes = copyTarget.getElementsByTagNameNS(this.copySettings.getDestinationElement().getNamespace().getUri(), this.copySettings.getDestinationElement().getElementName());
            XmlUtil.getAsElementList(childNodes).stream().map(XmlUtil::getElementText).forEach(valuesAlreadyPresent::add);
        }
        for (XpathQuery query : this.targetElements) {
            NodeList queryResult;
            try {
                queryResult = query.execute(edm);
            }
            catch (XPathExpressionException e) {
                throw new NormalizationException("Xpath query issue: " + e.getMessage(), e);
            }
            for (int i = 0; i < queryResult.getLength(); ++i) {
                Node node = queryResult.item(i);
                if (node instanceof Attr) {
                    this.normalizeAttribute(copyTarget, valuesAlreadyPresent, (Attr)node, report);
                    continue;
                }
                if (!(node instanceof Element)) continue;
                this.normalizeElement(copyTarget, valuesAlreadyPresent, (Element)node, report);
            }
        }
        return report;
    }

    private static Element getCopyTargetFromSettings(Document edm, CopySettings copySettings) throws NormalizationException {
        NodeList copyTargets;
        try {
            copyTargets = copySettings.getDestinationParent().execute(edm);
        }
        catch (XPathExpressionException e) {
            throw new NormalizationException("Xpath query issue: " + e.getMessage(), e);
        }
        if (copyTargets.getLength() != 1 || !(copyTargets.item(0) instanceof Element)) {
            throw new NormalizationException("The document does not contain a unique element to which to copy the normalized values.", null);
        }
        return (Element)copyTargets.item(0);
    }

    static class CopySettings {
        private final XpathQuery destinationParent;
        private final Namespace.Element destinationElement;
        private final Namespace.Element afterElement;

        CopySettings(XpathQuery destinationParent, Namespace.Element destinationElement, Namespace.Element afterElement) {
            if (destinationElement == null || destinationParent == null) {
                throw new IllegalArgumentException();
            }
            this.destinationParent = destinationParent;
            this.destinationElement = destinationElement;
            this.afterElement = afterElement;
        }

        Namespace.Element getDestinationElement() {
            return this.destinationElement;
        }

        Namespace.Element getAfterElement() {
            return this.afterElement;
        }

        XpathQuery getDestinationParent() {
            return this.destinationParent;
        }
    }
}

