/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.normalizers;

import eu.europeana.normalization.normalizers.NormalizedValueWithConfidence;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.normalizers.ValueNormalizeAction;
import eu.europeana.normalization.normalizers.ValueNormalizeActionWrapper;
import eu.europeana.normalization.util.Namespace;
import eu.europeana.normalization.util.XpathQuery;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.Violation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanIRIViolationsNormalizer
implements ValueNormalizeAction {
    private static final Logger LOG = LoggerFactory.getLogger(CleanIRIViolationsNormalizer.class);
    private static final Namespace.Element RDF_RESOURCE = Namespace.RDF.getElement("resource");
    private static final Namespace.Element RDF_ABOUT = Namespace.RDF.getElement("about");
    private static final Namespace.Element ORE_AGGREGATION = Namespace.ORE.getElement("Aggregation");
    private static final Namespace.Element EDM_IS_SHOWN_BY = Namespace.EDM.getElement("isShownBy");
    private static final Namespace.Element EDM_IS_SHOWN_AT = Namespace.EDM.getElement("isShownAt");
    private static final Namespace.Element EDM_OBJECT = Namespace.EDM.getElement("object");
    private static final Namespace.Element EDM_HAS_VIEW = Namespace.EDM.getElement("hasView");
    private static final Namespace.Element EDM_WEB_RESOURCE = Namespace.EDM.getElement("WebResource");
    private static final XpathQuery RESOURCE_IS_SHOWN_BY_QUERY = CleanIRIViolationsNormalizer.createResourceQueries(EDM_IS_SHOWN_BY);
    private static final XpathQuery RESOURCE_HAS_VIEW_QUERY = CleanIRIViolationsNormalizer.createResourceQueries(EDM_HAS_VIEW);
    private static final XpathQuery RESOURCE_IS_SHOWN_AT_QUERY = CleanIRIViolationsNormalizer.createResourceQueries(EDM_IS_SHOWN_AT);
    private static final XpathQuery RESOURCE_OBJECT_QUERY = CleanIRIViolationsNormalizer.createResourceQueries(EDM_OBJECT);
    private static final XpathQuery WEB_RESOURCE_ABOUT_QUERY = new XpathQuery("/%s/%s/@%s", XpathQuery.RDF_TAG, EDM_WEB_RESOURCE, RDF_ABOUT);
    private final IRIFactory iriFactory = IRIFactory.iriImplementation();
    private IRI iri = null;

    @Override
    public RecordNormalizeAction getAsRecordNormalizer() {
        return new ValueNormalizeActionWrapper((ValueNormalizeAction)this, RESOURCE_IS_SHOWN_BY_QUERY, RESOURCE_HAS_VIEW_QUERY, RESOURCE_IS_SHOWN_AT_QUERY, RESOURCE_OBJECT_QUERY, WEB_RESOURCE_ABOUT_QUERY);
    }

    @Override
    public List<NormalizedValueWithConfidence> normalizeValue(String value) {
        List<NormalizedValueWithConfidence> result = new ArrayList<NormalizedValueWithConfidence>();
        if (!StringUtils.isBlank((CharSequence)value)) {
            this.iri = this.iriFactory.create(value);
            try {
                String normalizedValue = this.iri.toURI().toString();
                result = Collections.singletonList(new NormalizedValueWithConfidence(normalizedValue, 1.0f));
            }
            catch (URISyntaxException e) {
                LOG.debug("There was some trouble normalizing the value for IRI Violation");
            }
        }
        return result;
    }

    Iterator<Violation> getViolations() {
        return this.iri == null ? Collections.emptyIterator() : this.iri.violations(false);
    }

    private static XpathQuery createResourceQueries(Namespace.Element edmValue) {
        return new XpathQuery("/%s/%s/%s/@%s", XpathQuery.RDF_TAG, ORE_AGGREGATION, edmValue, RDF_RESOURCE);
    }
}

