/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.model;

import eu.europeana.normalization.model.ConfidenceLevel;
import eu.europeana.normalization.model.NormalizationOperationReport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NormalizationReport {
    private final Map<String, NormalizationOperationReport> operations = new HashMap<String, NormalizationOperationReport>();

    public void mergeWith(NormalizationReport otherReport) {
        Set<Map.Entry<String, NormalizationOperationReport>> entrySet = otherReport.operations.entrySet();
        for (Map.Entry<String, NormalizationOperationReport> op : entrySet) {
            NormalizationOperationReport myOpRep = this.operations.get(op.getKey());
            if (myOpRep == null) {
                this.operations.put(op.getKey(), op.getValue());
                continue;
            }
            myOpRep.mergeWith(op.getValue());
        }
    }

    protected void increment(String operation, ConfidenceLevel confidence) {
        NormalizationOperationReport normalizationOperationReport = this.operations.computeIfAbsent(operation, key -> new NormalizationOperationReport());
        normalizationOperationReport.increment(confidence);
    }

    public Map<String, NormalizationOperationReport> getReportsPerOperation() {
        return Collections.unmodifiableMap(this.operations);
    }
}

