/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.languages;

import eu.europeana.normalization.languages.Language;
import eu.europeana.normalization.languages.LanguageLabel;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import eu.europeana.normalization.util.XmlException;
import eu.europeana.normalization.util.XmlUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Languages {
    private static Languages instance;
    private final List<Language> activeLanguages = new ArrayList<Language>();
    private final List<Language> deprecatedLanguages = new ArrayList<Language>();

    private Languages() throws NormalizationConfigurationException {
        Document langNalDom;
        InputStream nalFileIn = Thread.currentThread().getContextClassLoader().getResourceAsStream("languages.xml");
        try {
            langNalDom = XmlUtil.parseDom(new InputStreamReader(nalFileIn, StandardCharsets.UTF_8));
        }
        catch (XmlException e) {
            throw new NormalizationConfigurationException("Unexpected error while setting up the language repository: " + e.getMessage(), e);
        }
        this.processDom(langNalDom);
    }

    private void processDom(Document langNalDom) {
        List<Element> records = XmlUtil.elements(langNalDom.getDocumentElement(), "record");
        for (Element recordEl : records) {
            Language l = new Language();
            l.setIso6391(XmlUtil.getElementTextByTagName(recordEl, "iso-639-1"));
            l.setIso6392b(XmlUtil.getElementTextByTagName(recordEl, "iso-639-2b"));
            l.setIso6392t(XmlUtil.getElementTextByTagName(recordEl, "iso-639-2t"));
            l.setIso6393(XmlUtil.getElementTextByTagName(recordEl, "iso-639-3"));
            l.setAuthorityCode(XmlUtil.getElementTextByTagName(recordEl, "authority-code"));
            Element nameEl = XmlUtil.getElementByTagName(recordEl, "name");
            for (Element nameSubEl : XmlUtil.elements(nameEl)) {
                if ("original.name".equals(nameSubEl.getNodeName())) {
                    l.addOriginalNames(this.createLabels(nameSubEl));
                    continue;
                }
                if (!"alternative.name".equals(nameSubEl.getNodeName())) continue;
                l.addAlternativeNames(this.createLabels(nameSubEl));
            }
            Element labelEl = XmlUtil.getElementByTagName(recordEl, "label");
            l.addLabels(this.createLabels(labelEl));
            if ("true".equals(recordEl.getAttribute("deprecated"))) {
                this.deprecatedLanguages.add(l);
                continue;
            }
            this.activeLanguages.add(l);
        }
    }

    private List<LanguageLabel> createLabels(Element labelEl) {
        return XmlUtil.elements(labelEl, "lg.version").stream().map(this::createLabel).collect(Collectors.toList());
    }

    private LanguageLabel createLabel(Element nameVersionEl) {
        return new LanguageLabel(nameVersionEl.getTextContent(), nameVersionEl.getAttribute("lg"), nameVersionEl.getAttribute("script"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Languages getLanguages() throws NormalizationConfigurationException {
        Class<Languages> clazz = Languages.class;
        synchronized (Languages.class) {
            if (instance == null) {
                instance = new Languages();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<Language> getActiveLanguages() {
        return Collections.unmodifiableList(this.activeLanguages);
    }

    public List<Language> getDeprecatedLanguages() {
        return Collections.unmodifiableList(this.deprecatedLanguages);
    }
}

