/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.languages;

import eu.europeana.normalization.languages.Language;
import eu.europeana.normalization.languages.LanguageMatch;
import eu.europeana.normalization.languages.Languages;
import eu.europeana.normalization.languages.LanguagesVocabulary;
import eu.europeana.normalization.settings.AmbiguityHandling;
import eu.europeana.normalization.util.LanguageTag;
import eu.europeana.normalization.util.LanguageTagValueNormalizer;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LanguageMatcher {
    private static final Pattern LANGUAGE_CODE_MATCHER = Pattern.compile("\\A\\p{Alpha}{2,3}\\Z");
    private final int minimumLabelLength;
    private final AmbiguityHandling ambiguityHandling;
    private final List<LanguagesVocabulary> targetVocabularies;
    private final Function<String, List<LanguageTag>> languageTagValueNormalizer;
    private final Map<String, String> isoCodes = new HashMap<String, String>();
    private final Map<String, String> unambiguousLabels = new HashMap<String, String>();
    private final HashMap<String, List<String>> ambiguousLabels = new HashMap();

    public LanguageMatcher(int minimumLabelLength, AmbiguityHandling ambiguityHandling, List<LanguagesVocabulary> targetVocabularies) throws NormalizationConfigurationException {
        this(minimumLabelLength, ambiguityHandling, targetVocabularies, Languages.getLanguages(), LanguageTagValueNormalizer::normalize);
    }

    LanguageMatcher(int minimumLabelLength, AmbiguityHandling ambiguityHandling, List<LanguagesVocabulary> targetVocabularies, Languages languages, Function<String, List<LanguageTag>> languageTagValueNormalizer) {
        this.minimumLabelLength = minimumLabelLength;
        this.ambiguityHandling = ambiguityHandling;
        this.targetVocabularies = new ArrayList<LanguagesVocabulary>(targetVocabularies);
        this.languageTagValueNormalizer = languageTagValueNormalizer;
        languages.getActiveLanguages().forEach(this::index);
    }

    private void index(Language language) {
        String languageId = this.targetVocabularies.stream().map(language::getNormalizedLanguageId).filter(Objects::nonNull).findFirst().orElse(null);
        if (languageId == null) {
            return;
        }
        this.addCodeToIndex(language.getIso6391(), languageId);
        this.addCodeToIndex(language.getIso6392b(), languageId);
        this.addCodeToIndex(language.getIso6392t(), languageId);
        this.addCodeToIndex(language.getIso6393(), languageId);
        this.addCodeToIndex(language.getAuthorityCode(), languageId);
        for (String label : language.getAllLabels()) {
            if (label.length() < this.minimumLabelLength) continue;
            this.addLabelToIndex(label, languageId);
        }
    }

    private void addLabelToIndex(String label, String languageId) {
        List<LanguageTag> normalizationResult = this.languageTagValueNormalizer.apply(label);
        if (normalizationResult.size() != 1) {
            return;
        }
        String normalizedLabel = normalizationResult.get(0).getNormalizedInput();
        if (this.ambiguousLabels.containsKey(normalizedLabel)) {
            List<String> alternatives = this.ambiguousLabels.get(normalizedLabel);
            if (!alternatives.contains(languageId)) {
                alternatives.add(languageId);
            }
        } else if (this.unambiguousLabels.containsKey(normalizedLabel)) {
            if (!this.unambiguousLabels.get(normalizedLabel).equals(languageId)) {
                String oldValue = this.unambiguousLabels.remove(normalizedLabel);
                ArrayList<String> alternatives = new ArrayList<String>();
                alternatives.add(oldValue);
                alternatives.add(languageId);
                this.ambiguousLabels.put(normalizedLabel, alternatives);
            }
        } else {
            this.unambiguousLabels.put(normalizedLabel, languageId);
        }
    }

    private void addCodeToIndex(String code, String languageId) {
        if (code == null) {
            return;
        }
        if (!LANGUAGE_CODE_MATCHER.matcher(code.trim()).matches()) {
            throw new IllegalArgumentException("Provided code does not qualify as a code: " + code);
        }
        List<LanguageTag> normalization = this.languageTagValueNormalizer.apply(code);
        if (normalization.size() != 1 || normalization.get(0).getSubTag() != null) {
            throw new IllegalStateException("Empty ISO code, ISO code with spaces or ISO code with subtag detected: " + code);
        }
        String normalizedCode = normalization.get(0).getLanguageCode();
        if (this.isoCodes.containsKey(normalizedCode) && !this.isoCodes.get(normalizedCode).equals(languageId)) {
            throw new IllegalStateException("Ambiguous iso code detected: " + normalizedCode);
        }
        this.isoCodes.put(normalizedCode, languageId);
    }

    public List<LanguageMatch> match(String input) {
        return this.languageTagValueNormalizer.apply(input).stream().map(this::matchNormalizedWord).collect(Collectors.toList());
    }

    private LanguageMatch matchNormalizedWord(LanguageTag languageTag) {
        List<String> ambiguousMatch;
        String unambiguousMatch;
        LanguageMatch result = null;
        String codeMatch = this.isoCodes.get(languageTag.getLanguageCode());
        if (codeMatch != null) {
            result = new LanguageMatch(languageTag.getNormalizedInput(), codeMatch + (languageTag.getSubTag() == null ? "" : languageTag.getSubTag()), LanguageMatch.Type.CODE_MATCH);
        }
        if (result == null && (unambiguousMatch = this.unambiguousLabels.get(languageTag.getNormalizedInput())) != null) {
            result = new LanguageMatch(languageTag.getNormalizedInput(), unambiguousMatch, LanguageMatch.Type.LABEL_MATCH);
        }
        if (result == null && (ambiguousMatch = this.ambiguousLabels.get(languageTag.getNormalizedInput())) != null) {
            String match = this.ambiguityHandling.resolveAmbiguousMatch(ambiguousMatch);
            result = new LanguageMatch(languageTag.getNormalizedInput(), match, match == null ? LanguageMatch.Type.NO_MATCH : LanguageMatch.Type.LABEL_MATCH);
        }
        if (result == null) {
            result = new LanguageMatch(languageTag.getNormalizedInput(), null, LanguageMatch.Type.NO_MATCH);
        }
        return result;
    }
}

